/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("UnusedDeclaration")
public class TypeaheadResult {
	public TypeaheadResult(String text, @NotNull String task) {
		this.text = text;
		this.taskId = task;
	}
	
	public TypeaheadResult(String text) {
		this.text = text;
		this.taskId = null;
	}
	
	// mandatory
	public final String text;
	// optional, often null
	@Nullable
	public final String taskId;

	@SuppressWarnings("StringBufferReplaceableByString")
	@NotNull
	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("TypeaheadResult{");
		sb.append("text='").append(text).append('\'');
		sb.append(", taskId='").append(taskId).append('\'');
		sb.append('}');
		return sb.toString();
	}
}
