/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.connector;

import com.codota.service.client.CodotaResponse;
import com.codota.service.client.EmptyTimeTracker;
import com.codota.service.client.ITimeTracker;
import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.client.requests.base.PutRequest;
import com.codota.service.client.requests.base.Request;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServiceConnector {
    protected static final String ENCODING = "UTF-8";
    protected static final String AUTH_ATTR = "authorization";
    protected static final String ORIGIN_ATTR = "origin";
    protected static final String ORIGIN = "https://intellij.codota.com";
    protected static final String CLIENT_ATTR = "apiversion";
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final ITimeTracker tracker = EmptyTimeTracker.instance();
    private final String base;

    public ServiceConnector(String base) {
        this.base = base;
    }

    @NotNull
    public static String encodeAttributes(@NotNull Map<String, String> attributes) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), ENCODING));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), ENCODING));
        }
        return result.toString();
    }

    @NotNull
    public static String encodeFullAttributes(@NotNull Map<String, String> attributes) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : attributes.entrySet()) {
            if (first) {
                first = false;
                result.append("?");
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), ENCODING));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), ENCODING));
        }
        return result.toString();
    }

    @NotNull
    public String getURI(String route, @Nullable String query, @Nullable Map<String, String> attributes) throws IOException {
        String encodedQuery = "";
        if (query != null) {
            encodedQuery = URLEncoder.encode(query, ENCODING);
        }
        String baseString = route + encodedQuery;
        String encodedAttributes = "";
        if (attributes != null) {
            try {
                encodedAttributes = ServiceConnector.encodeFullAttributes(attributes);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return baseString + encodedAttributes;
    }

    @NotNull
    protected String consumeResponse(@NotNull HttpResponse response) throws IllegalStateException, IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(response.getEntity().getContent()), "utf-8"));
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        br.close();
        return sb.toString();
    }

    public void clear() {
    }

    @Nullable
    public abstract CodotaResponse post(String var1, Map<String, String> var2, String var3);

    @Nullable
    public abstract CodotaResponse postJson(String var1, String var2, String var3);

    public abstract CodotaResponse post(Request var1);

    public abstract CodotaResponse get(GetRequest var1);

    public abstract CodotaResponse put(PutRequest var1);

    public String getBase() {
        return this.base;
    }
}

