/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.model;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Location
implements Comparable<Location> {
    public int length;
    public int col;
    public int line;
    @Nullable
    public String unitName;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (this.length != location.length) {
            return false;
        }
        if (this.col != location.col) {
            return false;
        }
        if (this.line != location.line) {
            return false;
        }
        return this.unitName != null ? this.unitName.equals(location.unitName) : location.unitName == null;
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + this.col;
        result = 31 * result + this.line;
        result = 31 * result + (this.unitName != null ? this.unitName.hashCode() : 0);
        return result;
    }

    public Location(@NotNull Map locMap) {
        Object mLength = locMap.get("length");
        Object mCol = locMap.get("col");
        Object mLine = locMap.get("line");
        Object mUnitName = locMap.get("unitName");
        if (mLength instanceof Double) {
            this.length = ((Double)mLength).intValue();
        }
        if (mCol instanceof Double) {
            this.col = ((Double)mCol).intValue();
        }
        if (mLine instanceof Double) {
            this.line = ((Double)mLine).intValue();
        }
        if (mUnitName != null && mUnitName instanceof String) {
            this.unitName = (String)mUnitName;
        }
    }

    @Override
    public int compareTo(Location other) {
        int unitCompareTo = 0;
        if (other == null) {
            return 0;
        }
        if (this.unitName != null && other.unitName != null) {
            unitCompareTo = this.unitName.compareTo(other.unitName);
        }
        if (unitCompareTo != 0) {
            return unitCompareTo;
        }
        int lineDiff = this.line - other.line;
        if (lineDiff != 0) {
            return lineDiff;
        }
        int colDiff = this.col - other.col;
        return colDiff;
    }
}

