/*
 * Decompiled with CFR 0.152.
 */
package com.codota.service.model;

import com.codota.service.model.AccountInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserInfo {
    public static final UserInfo UNKNOWN = new UserInfo();
    public String identifier;
    public String email;
    public String displayName;
    public String avatarUrl;
    public boolean hasTrackingAlias;
    public boolean justLoggedIn;
    public AccountInfo accountInfo;

    public List<String> getCodePacks() {
        if (this.accountInfo != null && this.accountInfo.packs != null) {
            return this.accountInfo.packs;
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getDecryptURL() {
        if (this.accountInfo != null && this.accountInfo.decryptionUrl != null) {
            return this.accountInfo.decryptionUrl;
        }
        return null;
    }

    @Nullable
    public String getFirstPack() {
        if (this.accountInfo != null) {
            return this.accountInfo.firstPack();
        }
        return null;
    }

    public String getAccountName() {
        if (this.accountInfo != null) {
            return this.accountInfo.name;
        }
        return "";
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier);
        sb.append("\n");
        sb.append(this.email);
        sb.append("\n");
        sb.append(this.displayName);
        sb.append("\n");
        sb.append(this.avatarUrl);
        sb.append("\n");
        sb.append(this.hasTrackingAlias);
        sb.append("\n");
        sb.append(this.justLoggedIn);
        sb.append("\n");
        if (this.accountInfo != null) {
            sb.append(this.accountInfo.toString());
        }
        return sb.toString();
    }
}

