package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Snippet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by yahave on 21/12/2016.
 */
public class BoxRequest extends GetRequest<List<Snippet>> {

    private static final String BOX_SNIPPETS_ROUTE = "/api/user-snippets";

    public BoxRequest(ServiceConnector connector, String token) {
        super(connector,connector.getBase() + BOX_SNIPPETS_ROUTE, token, null);
    }

    @Override
    public List<Snippet> parse(String json) {
        List<Snippet> sr = new ArrayList<Snippet>();
        try {
            JsonParser parser = new JsonParser();
            JsonArray root = parser.parse(json).getAsJsonArray();
            for (JsonElement elem : root) {
                Snippet snip = gson.fromJson(elem, Snippet.class);
                sr.add(snip);
            }
        } catch (IllegalStateException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + json);
            e.printStackTrace();
        }
        return sr;
    }
}
