/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.client.requests;

import com.codota.service.client.CodotaHttpException;
import com.codota.service.client.CodotaResponse;
import com.codota.service.client.requests.base.Request;
import com.codota.service.connector.ConnectorSettings;
import com.codota.service.connector.ServiceConnector;
import com.codota.service.model.Bookmark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by yahave on 3/3/16.
 * (C) Codota
 */
public class DecryptRequest extends Request {
    final Bookmark bookmark;
    public DecryptRequest(ServiceConnector connector, String route, String token, Bookmark bookmark) {
        super(connector, route, token);
        this.bookmark = bookmark;
    }

    /***
     * data=json.dumps({'reqData':[[
     * encrypted_key.encode('base64'),
     * encrypted_iv.encode('base64'),
     * encrypted_text.encode('base64')]]}),
     * headers={"Content-type": "application/json"},
     * verify=False)
     */
    @Nullable
    public String run() throws CodotaHttpException {

        Map<String,String[][]> payload  = new HashMap<String,String[][]>();
        String[] triplet = { bookmark.encryption_key, bookmark.encryption_iv, bookmark.sourceLine };
        String[][] reqData = { triplet };

        payload.put("reqData", reqData);

        String g = gson.toJson(payload);

        CodotaResponse response = connector.postJson(getRoute(), g, getToken());

        return response != null ? handleDecryptResponse(response) : null;
    }

    public String handleDecryptResponse(@NotNull CodotaResponse response) throws CodotaHttpException {
        String result;
        if (response.isOK()) {
            result = response.content;
        } else {
            ConnectorSettings.LOG.warn("response status: " + response.status);
            throw new CodotaHttpException(response.status, response.content);
        }
        return result;
    }

}
