/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import java.util.Collection;

/**
 * Created by WEISS on 26/07/2016.
 */
public class DependencyInfo {

    private Collection<InternalDependency> internalDeps;
    private Collection<String> externalDeps;
    private Collection<String> externalImportOnlyDeps;
    private Collection<Collection<OptionalInternalDependency>> internalDepsExtended;
    private Collection<String> externalManualDeps;


    public Collection<InternalDependency> getInternalDeps() {
        return internalDeps;
    }

    /**
     * The extended internal dependencies is a collection of collections of dependencies.
     * Each item in the external collection is a required *group* where the internal items in each group are
     * alternatives sources that satisfy the requirement in this group.
     *
     * In other words, you need one optional dependency from each of the groups
     */
    public Collection<Collection<OptionalInternalDependency>> getInternalDepsExtended() {
        return internalDepsExtended;
    }

    public Collection<String> getExternalDeps() {
        return externalDeps;
    }

    public Collection<String> getExternalImportOnlyDeps() {
        return externalImportOnlyDeps;
    }

    public Collection<String> getExternalManualDeps() { return externalManualDeps; }

    /**
     * Dependency on source/internal object
     */
    public static class InternalDependency {
        private Collection<String> artifactNames;
        private String filepath;


        public Collection<String> getArtifactNames() {
            return artifactNames;
        }

        public String getFilepath() {
            return filepath;
        }

        @Override
        public String toString() {
            return "InternalDependency{" +
                    "artifactNames='" + artifactNames + '\'' +
                    ", filepath='" + filepath + '\'' +
                    '}';
        }
    }

    /**
     * Dependency on a specific source/internal object
     */
    public static class OptionalInternalDependency {
        private String artifactName;
        private String filepath;
        private DependencyMetadata metadata;
        private DependencyOrigin origin = DependencyOrigin.Analysed;

        public String getArtifactName() {
            return artifactName;
        }

        public String getFilepath() {
            return filepath;
        }

        public DependencyMetadata getMetadata() { return metadata; }

        public DependencyOrigin getOrigin() { return origin; }

        @Override
        public String toString() {
            return "OptionalInternalDependency{" +
                    "artifactName='" + artifactName + '\'' +
                    ", filepath='" + filepath + '\'' +
                    ", origin='" + origin + "'" +
                    '}';
        }
    }

    public static class DependencyMetadata {
        private String label;

        public String getLabel() { return label; }

        @Override
        public String toString() {
            return "DependencyMetadata{" +
                    "label='" + label + '\'' +
                    '}';
        }
    }


}
