/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

import org.jetbrains.annotations.NotNull;

import java.util.List;

@SuppressWarnings("UnusedDeclaration")
public class Scenario implements CodeFragment {
	protected String _id;
	protected List<String> classes;
	protected Example source;
	protected Origin origin;
	protected String url;

	// public NormalizedScore normalizedScore;

	@NotNull
	public String toString() {
		return _id + "--" + source;
	}

	@Override
	public List<Annotation> annotations() {
		return source.annotations;
	}

	public Example getExample() {
		return source;
	}

	@Override
	public String code() {
		return source.rawSource.sourceCode;
	}

	@Override
	public String codeSummary() {
		return source.formatted.summary;
	}

	@Override
	public String copySummary() {
		return source.formatted.copySummary;
	}

	@Override
	public String id() {
		return _id;
	}

	@Override
	public String url() {
		return url;
	}

	@Override
	public String originUrl() {
		return origin.url;
	}

	@Override
	public String urlTitle() {
		return origin.urlTitle;
	}

}
