/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.model;

/**
 * Created by yahave on 4/23/16.
 * (C) Codota
 */
public class XRefMethodItem {
    /**
     * Example:
     * { "key":"Lcom/amazonaws/services/simpledb/model/RequestTimeoutException;getBoxUsage()Ljava/lang/Float;",
     *   "type":"METHOD",
     *   "name":"getBoxUsage",
     *   "signature":"()"
     * }
     */

    public String key;
    public String type;
    public String name;
    public String signature;

    @SuppressWarnings("StringBufferReplaceableByString")
    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("XRefMethodItem{");
        sb.append("key='").append(key).append('\'');
        sb.append(", type='").append(type).append('\'');
        sb.append(", name='").append(name).append('\'');
        sb.append(", signature='").append(signature).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
