package com.codota.service.client.requests;

import com.codota.service.client.requests.base.GetRequest;
import com.codota.service.connector.ServiceConnector;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by shaia on 24/05/2017.
 */
public class GetManualDependenciesRequest extends GetRequest<List<String>> {

    private static final String ROUTE = "/api/codenav/manualDependencies";

    public GetManualDependenciesRequest(ServiceConnector connector, String artifactName, String codePack,
                                        String filePath, String token) {
        super(connector, connector.getBase() + ROUTE, null,
                buildProps(artifactName, codePack, filePath), token);
    }

    private static Map<String, String> buildProps(String artifactName, String codePack, String filePath) {
        Map<String, String> props = new HashMap<String, String>();
        props.put("artifactName", artifactName);
        props.put("codePack", codePack);
        props.put("filepath", filePath);
        return props;
    }

    @NotNull
    public List<String> parse(@NotNull String response) {
        String[] result = new String[0];
        try {
            result = gson.fromJson(response, String[].class);
        } catch (IllegalStateException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        } catch (com.google.gson.JsonSyntaxException e) {
            System.err.println("json" + response);
            e.printStackTrace();
        }
        return Arrays.asList(result);
    }
}
