/*
 * Copyright (C) 2016 Codota
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.codota.service.utils;

import org.jetbrains.annotations.NotNull;

/**
 * Created by yahave on 6/5/16.
 * (C) Codota
 */
public class LogUtils {

    public static String shorten(@NotNull String in) {
        return shorten(in,100);
    }

    public static String shorten(@NotNull String in,int maxLen) {
        if (maxLen <=0) return "";
        if (in.length() > maxLen) {
            return in.substring(0,Math.min(in.length(),maxLen)) + "...";
        } else {
            return in;
        }
    }
}
