/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.httpserver.spi;

import com.devops4j.embedded.httpserver.HttpServer;
import com.devops4j.embedded.httpserver.HttpsServer;
import com.devops4j.embedded.httpserver.impl.DefaultHttpServerProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class HttpServerProvider {
    private static final Object lock = new Object();
    private static HttpServerProvider provider = null;

    public abstract HttpServer createHttpServer(InetSocketAddress var1, int var2) throws IOException;

    public abstract HttpsServer createHttpsServer(InetSocketAddress var1, int var2) throws IOException;

    protected HttpServerProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("httpServerProvider"));
        }
    }

    private static boolean loadProviderFromProperty() {
        String cn = System.getProperty("com.sun.net.httpserver.HttpServerProvider");
        if (cn == null) {
            return false;
        }
        try {
            Object o = Class.forName(cn, true, ClassLoader.getSystemClassLoader()).newInstance();
            provider = (HttpServerProvider)o;
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException x) {
            throw new ServiceConfigurationError(null, x);
        }
    }

    private static boolean loadProviderAsService() {
        Iterator<HttpServerProvider> i = ServiceLoader.load(HttpServerProvider.class, ClassLoader.getSystemClassLoader()).iterator();
        while (true) {
            try {
                if (!i.hasNext()) {
                    return false;
                }
                provider = i.next();
                return true;
            }
            catch (ServiceConfigurationError sce) {
                if (sce.getCause() instanceof SecurityException) continue;
                throw sce;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServerProvider provider() {
        Object object = lock;
        synchronized (object) {
            if (provider != null) {
                return provider;
            }
            return (HttpServerProvider)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (HttpServerProvider.loadProviderFromProperty()) {
                        return provider;
                    }
                    if (HttpServerProvider.loadProviderAsService()) {
                        return provider;
                    }
                    provider = (HttpServerProvider)new DefaultHttpServerProvider();
                    return provider;
                }
            });
        }
    }
}

