package com.devops4j.embedded.handler;

import com.devops4j.embedded.servlet.EmbeddedHttpServletRequest;
import com.devops4j.embedded.servlet.EmbeddedHttpServletResponse;
import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.embedded.httpserver.HttpHandler;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

/**
 * Created by devops4j on 2018/1/26.
 */
public class DelegateHttpHandler implements HttpHandler {
    Executor executor;
    ClassLoader classLoader;
    final Map<String, HttpServlet> servlets;
    final boolean forceHttps;

    public DelegateHttpHandler(ClassLoader classLoader, Executor executor, Map<String, HttpServlet> servlets, boolean forceHttps) {
        this.classLoader = classLoader;
        this.executor = executor;
        if (servlets == null) {
            this.servlets = new HashMap();
        } else {
            this.servlets = servlets;
        }
        this.forceHttps = forceHttps;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        final EmbeddedHttpServletRequest request = new EmbeddedHttpServletRequest(exchange);
        final EmbeddedHttpServletResponse response = new EmbeddedHttpServletResponse(exchange);
        this.executor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    if(forceHttps && request.getScheme().equalsIgnoreCase("http")){
                        String newUrl = "https://" + request.getServerName() + request.getContextPath();
                        if (!request.getQueryString().isEmpty()) {
                            newUrl += "?" + request.getQueryString();
                        }
                        System.out.println(newUrl);
                        response.sendRedirect(newUrl);
                        return;
                    }
                    final Servlet servlet = servlets.get(request.getRequestURI());
                    if (servlet != null) {//存在定义的Servlet，使用Servlet执行
                        servlet.service(request, response);
                        response.setStatus(HttpServletResponse.SC_OK);
                    } else {//不存在
                        response.setStatus(HttpServletResponse.SC_NOT_FOUND);
                    }
                } catch (ServletException e) {
                    try {
                        response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
                    } catch (IOException e1) {
                        //nothing
                    }
                } catch (IOException e) {
                    try {
                        response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, e.getLocalizedMessage());
                    } catch (IOException e1) {
                        //nothing
                    }
                } finally {
                    try {
                        response.flushBuffer();
                    } catch (IOException e) {
                        throw new RuntimeException("写入结果发生异常", e);
                    }
                }
            }
        });
    }

}
