/*
 * Decompiled with CFR 0.152.
 */
package com.devops4j.embedded.servlet;

import com.devops4j.embedded.httpserver.Headers;
import com.devops4j.embedded.httpserver.HttpExchange;
import com.devops4j.embedded.servlet.EmbeddedServletOutputStream;
import com.devops4j.io.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class EmbeddedHttpServletResponse
implements HttpServletResponse {
    private boolean outputStreamAccessAllowed = true;
    private boolean writerAccessAllowed = true;
    private String characterEncoding = "UTF-8";
    private boolean charset = false;
    private ByteArrayOutputStream content = new ByteArrayOutputStream(1024);
    private long contentLength = 0L;
    private String contentType;
    private int bufferSize = 4096;
    private boolean committed;
    private Locale locale = Locale.getDefault();
    HttpExchange exchange;
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Map<String, List<Object>> headers = new ConcurrentHashMap<String, List<Object>>();
    private int status = 200;
    private String errorMessage;
    private String forwardedUrl;
    private final List<String> includedUrls = new ArrayList<String>();
    ByteBuf byteBuf = ByteBuf.allocate((int)1024).autoExpand(true);

    public EmbeddedHttpServletResponse(HttpExchange exchange) {
        this.exchange = exchange;
        this.setHeader("Access-Control-Allow-Origin", "*");
        this.setHeader("Access-Control-Allow-Methods", "GET,POST");
        this.setHeader("Access-Control-Allow-Headers", "POWERED-BY-FANTONG");
        this.setHeader("Access-Control-Max-Age", "30");
        this.setHeader("Access-Control-Max-Age", "30");
        this.setHeader("Content-Type", "text/html; charset=UTF-8");
        this.setStatus(200);
    }

    public void write(String msg) {
        this.byteBuf.put("UTF-8", new String[]{msg});
    }

    public void write(byte[] data) {
        this.byteBuf.put(data);
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.setStatus(sc);
    }

    public void sendError(int sc) throws IOException {
        this.setStatus(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(301);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
    }

    public void addDateHeader(String name, long date) {
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            this.doAddHeaderValue(name, value);
        }
        Headers headers = this.exchange.getResponseHeaders();
        headers.set(name, value);
    }

    private void doAddHeaderValue(String name, Object value) {
        List<Object> header0 = this.headers.get(name);
        if (header0 == null) {
            header0 = new ArrayList<Object>();
            this.headers.put(name, header0);
        }
        header0.add(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void addIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setStatus(int sc, String sm) {
    }

    public String getHeader(String name) {
        List<Object> header_ = this.headers.get(name);
        if (header_ != null && !header_.isEmpty()) {
            return header_.get(0) == null ? null : header_.get(0).toString();
        }
        return null;
    }

    public Collection<String> getHeaders(String name) {
        List<Object> header_ = this.headers.get(name);
        ArrayList<String> header_1 = new ArrayList<String>();
        for (Object value : header_) {
            header_1.add(value == null ? null : value.toString());
        }
        return header_1;
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new EmbeddedServletOutputStream(this.byteBuf);
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = new PrintWriter((OutputStream)this.getOutputStream());
        return writer;
    }

    public void setContentLength(int len) {
        this.byteBuf.capacity(len);
    }

    public void setContentLengthLong(long len) {
        this.byteBuf.capacity((int)len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        this.exchange.sendResponseHeaders(this.status, this.byteBuf.readableLength());
        OutputStream os = this.exchange.getResponseBody();
        try {
            int byteWriteLen = 0;
            while ((byteWriteLen = this.byteBuf.readableLength()) > 0) {
                byte[] data = new byte[Math.min(1024, byteWriteLen)];
                this.byteBuf.get(data);
                os.write(data);
            }
        }
        finally {
            this.exchange.close();
            if (os != null) {
                os.close();
            }
        }
    }

    public void resetBuffer() {
        this.byteBuf.clear();
    }

    public void reset() {
        this.byteBuf.clear();
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.outputStreamAccessAllowed;
    }

    public boolean isWriterAccessAllowed() {
        return this.writerAccessAllowed;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public boolean isCharset() {
        return this.charset;
    }

    public ByteArrayOutputStream getContent() {
        return this.content;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public HttpExchange getExchange() {
        return this.exchange;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Map<String, List<Object>> getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getForwardedUrl() {
        return this.forwardedUrl;
    }

    public List<String> getIncludedUrls() {
        return this.includedUrls;
    }

    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    public void setOutputStreamAccessAllowed(boolean outputStreamAccessAllowed) {
        this.outputStreamAccessAllowed = outputStreamAccessAllowed;
    }

    public void setWriterAccessAllowed(boolean writerAccessAllowed) {
        this.writerAccessAllowed = writerAccessAllowed;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setCharset(boolean charset) {
        this.charset = charset;
    }

    public void setContent(ByteArrayOutputStream content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setExchange(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setForwardedUrl(String forwardedUrl) {
        this.forwardedUrl = forwardedUrl;
    }

    public void setByteBuf(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddedHttpServletResponse)) {
            return false;
        }
        EmbeddedHttpServletResponse other = (EmbeddedHttpServletResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOutputStreamAccessAllowed() != other.isOutputStreamAccessAllowed()) {
            return false;
        }
        if (this.isWriterAccessAllowed() != other.isWriterAccessAllowed()) {
            return false;
        }
        String this$characterEncoding = this.getCharacterEncoding();
        String other$characterEncoding = other.getCharacterEncoding();
        if (this$characterEncoding == null ? other$characterEncoding != null : !this$characterEncoding.equals(other$characterEncoding)) {
            return false;
        }
        if (this.isCharset() != other.isCharset()) {
            return false;
        }
        ByteArrayOutputStream this$content = this.getContent();
        ByteArrayOutputStream other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        if (this.getContentLength() != other.getContentLength()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        if (this.isCommitted() != other.isCommitted()) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        HttpExchange this$exchange = this.getExchange();
        HttpExchange other$exchange = other.getExchange();
        if (this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange)) {
            return false;
        }
        List<Cookie> this$cookies = this.getCookies();
        List<Cookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        Map<String, List<Object>> this$headers = this.getHeaders();
        Map<String, List<Object>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$forwardedUrl = this.getForwardedUrl();
        String other$forwardedUrl = other.getForwardedUrl();
        if (this$forwardedUrl == null ? other$forwardedUrl != null : !this$forwardedUrl.equals(other$forwardedUrl)) {
            return false;
        }
        List<String> this$includedUrls = this.getIncludedUrls();
        List<String> other$includedUrls = other.getIncludedUrls();
        if (this$includedUrls == null ? other$includedUrls != null : !((Object)this$includedUrls).equals(other$includedUrls)) {
            return false;
        }
        ByteBuf this$byteBuf = this.getByteBuf();
        ByteBuf other$byteBuf = other.getByteBuf();
        return !(this$byteBuf == null ? other$byteBuf != null : !this$byteBuf.equals(other$byteBuf));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddedHttpServletResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOutputStreamAccessAllowed() ? 79 : 97);
        result = result * 59 + (this.isWriterAccessAllowed() ? 79 : 97);
        String $characterEncoding = this.getCharacterEncoding();
        result = result * 59 + ($characterEncoding == null ? 43 : $characterEncoding.hashCode());
        result = result * 59 + (this.isCharset() ? 79 : 97);
        ByteArrayOutputStream $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        long $contentLength = this.getContentLength();
        result = result * 59 + (int)($contentLength >>> 32 ^ $contentLength);
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        result = result * 59 + this.getBufferSize();
        result = result * 59 + (this.isCommitted() ? 79 : 97);
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        HttpExchange $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        List<Cookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        Map<String, List<Object>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + this.getStatus();
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $forwardedUrl = this.getForwardedUrl();
        result = result * 59 + ($forwardedUrl == null ? 43 : $forwardedUrl.hashCode());
        List<String> $includedUrls = this.getIncludedUrls();
        result = result * 59 + ($includedUrls == null ? 43 : ((Object)$includedUrls).hashCode());
        ByteBuf $byteBuf = this.getByteBuf();
        result = result * 59 + ($byteBuf == null ? 43 : $byteBuf.hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddedHttpServletResponse(outputStreamAccessAllowed=" + this.isOutputStreamAccessAllowed() + ", writerAccessAllowed=" + this.isWriterAccessAllowed() + ", characterEncoding=" + this.getCharacterEncoding() + ", charset=" + this.isCharset() + ", content=" + this.getContent() + ", contentLength=" + this.getContentLength() + ", contentType=" + this.getContentType() + ", bufferSize=" + this.getBufferSize() + ", committed=" + this.isCommitted() + ", locale=" + this.getLocale() + ", exchange=" + this.getExchange() + ", cookies=" + this.getCookies() + ", headers=" + this.getHeaders() + ", status=" + this.getStatus() + ", errorMessage=" + this.getErrorMessage() + ", forwardedUrl=" + this.getForwardedUrl() + ", includedUrls=" + this.getIncludedUrls() + ", byteBuf=" + this.getByteBuf() + ")";
    }
}

