/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj;

import com.diozero.ws281xj.PixelColour;
import com.diozero.ws281xj.WS281xNative;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class WS281x
implements Closeable {
    private static final int SIZE_OF_INT = 4;
    private static final int DEFAULT_FREQUENCY = 800000;
    private static final int DEFAULT_DMA_NUM = 5;
    private static final String LIB_NAME = "ws281xj";
    private static Boolean loaded = Boolean.FALSE;
    private ByteBuffer ch0LedBuffer;
    private int numPixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Boolean bl = loaded;
        synchronized (bl) {
            if (!loaded.booleanValue()) {
                try {
                    Path path = Files.createTempFile("libws281xj", ".so", new FileAttribute[0]);
                    path.toFile().deleteOnExit();
                    Files.copy(WS281x.class.getResourceAsStream("/lib/libws281xj.so"), path, StandardCopyOption.REPLACE_EXISTING);
                    System.load(path.toString());
                    loaded = Boolean.TRUE;
                }
                catch (IOException iOException) {
                    System.out.println("Error loading library from classpath: " + iOException);
                    iOException.printStackTrace();
                    System.loadLibrary(LIB_NAME);
                    loaded = Boolean.TRUE;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(WS281xNative::terminate, "WS281x Shutdown Handler"));
            }
        }
    }

    public WS281x(int n, int n2, int n3) {
        this(800000, 5, n, n2, n3);
    }

    public WS281x(int n, int n2, int n3, int n4, int n5) {
        WS281x.init();
        this.numPixels = n5;
        this.ch0LedBuffer = WS281xNative.initialise(n, n2, n3, n4, n5);
        System.out.println("order=" + this.ch0LedBuffer.order());
        this.ch0LedBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void close() {
        System.out.println("close()");
        this.allOff();
        this.ch0LedBuffer = null;
        WS281xNative.terminate();
    }

    public int getNumPixels() {
        return this.numPixels;
    }

    public void render() {
        int n = WS281xNative.render();
        if (n != 0) {
            throw new RuntimeException("Error in render() - " + n);
        }
    }

    private void validatePixel(int n) {
        if (n < 0 || n >= this.numPixels) {
            throw new IllegalArgumentException("pixel must be 0.." + (this.numPixels - 1));
        }
    }

    public void allOff() {
        for (int i = 0; i < this.numPixels; ++i) {
            this.setPixelColour(i, 0);
        }
        this.render();
    }

    public int getPixelColour(int n) {
        this.validatePixel(n);
        return this.ch0LedBuffer.getInt(n * 4);
    }

    public void setPixelColour(int n, int n2) {
        this.validatePixel(n);
        this.ch0LedBuffer.putInt(n * 4, n2);
    }

    public void setPixelColourRGB(int n, int n2, int n3, int n4) {
        this.validatePixel(n);
        this.ch0LedBuffer.putInt(n * 4, PixelColour.createColourRGB(n2, n3, n4));
    }

    public void setPixelColourHSB(int n, float f, float f2, float f3) {
        this.validatePixel(n);
        this.ch0LedBuffer.putInt(n * 4, PixelColour.createColourHSB(f, f2, f3));
    }

    public void setPixelColourHSL(int n, float f, float f2, float f3) {
        this.validatePixel(n);
        this.ch0LedBuffer.putInt(n * 4, PixelColour.createColourHSL(f, f2, f3));
    }

    public int getRedComponent(int n) {
        this.validatePixel(n);
        return PixelColour.getRedComponent(this.ch0LedBuffer.getInt(n * 4));
    }

    public void setRedComponent(int n, int n2) {
        this.validatePixel(n);
        int n3 = n * 4;
        this.ch0LedBuffer.putInt(n3, PixelColour.setRedComponent(this.ch0LedBuffer.getInt(n3), n2));
    }

    public int getGreenComponent(int n) {
        this.validatePixel(n);
        return PixelColour.getGreenComponet(this.ch0LedBuffer.getInt(n * 4));
    }

    public void setGreenComponent(int n, int n2) {
        this.validatePixel(n);
        int n3 = n * 4;
        this.ch0LedBuffer.putInt(n3, PixelColour.setGreenComponent(this.ch0LedBuffer.getInt(n3), n2));
    }

    public int getBlueComponent(int n) {
        this.validatePixel(n);
        return PixelColour.getBlueComponent(this.ch0LedBuffer.getInt(n * 4));
    }

    public void setBlueComponent(int n, int n2) {
        this.validatePixel(n);
        int n3 = n * 4;
        this.ch0LedBuffer.putInt(n3, PixelColour.setBlueComponent(this.ch0LedBuffer.getInt(n3), n2));
    }
}

