/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj;

import java.awt.Color;

public class PixelColour {
    public static final int RED = 0x200000;
    public static final int ORANGE = 0x201000;
    public static final int YELLOW = 0x202000;
    public static final int GREEN = 8192;
    public static final int LIGHT_BLUE = 8224;
    public static final int BLUE = 32;
    public static final int PURPLE = 0x100010;
    public static final int PINK = 0x200010;
    public static final int[] RAINBOW = new int[]{0x200000, 0x201000, 0x202000, 8192, 8224, 32, 0x100010, 0x200010};
    private static final int WHITE_MASK = 0xFFFFFF;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_OFF_MASK = 65535;
    private static final int GREEN_OFF_MASK = 0xFF00FF;
    private static final int BLUE_OFF_MASK = 0xFFFF00;
    public static final int COLOUR_COMPONENT_MAX = 255;

    public static int wheel(int n) {
        int n2 = 255;
        int n3 = 85;
        int n4 = 170;
        int n5 = n2 - n;
        if (n5 < n3) {
            return PixelColour.createColourRGB(n2 - n5 * 3, 0, n5 * 3);
        }
        if (n5 < n4) {
            return PixelColour.createColourRGB(0, (n5 -= n3) * 3, n2 - n5 * 3);
        }
        return PixelColour.createColourRGB((n5 -= n4) * 3, n2 - n5 * 3, 0);
    }

    public static int createColourRGB(float f, float f2, float f3) {
        return PixelColour.createColourRGB((int)(255.0f * f), (int)(255.0f * f2), (int)(255.0f * f3));
    }

    public static int createColourRGB(int n, int n2, int n3) {
        PixelColour.validateColourComponent("Red", n);
        PixelColour.validateColourComponent("Green", n2);
        PixelColour.validateColourComponent("Blue", n3);
        return n << 16 | n2 << 8 | n3;
    }

    public static int createColourHSB(float f, float f2, float f3) {
        return Color.HSBtoRGB(f, f2, f3) & 0xFFFFFF;
    }

    public static int createColourHSL(float f, float f2, float f3) {
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f3 < 0.0f || f3 > 1.0f) {
            String string = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(string);
        }
        f %= 360.0f;
        float f4 = 0.0f;
        f4 = (double)f3 < 0.5 ? f3 * (1.0f + f2) : f3 + f2 - f2 * f3;
        float f5 = 2.0f * f3 - f4;
        float f6 = Math.max(0.0f, PixelColour.HueToRGB(f5, f4, (f /= 360.0f) + 0.33333334f));
        float f7 = Math.max(0.0f, PixelColour.HueToRGB(f5, f4, f));
        float f8 = Math.max(0.0f, PixelColour.HueToRGB(f5, f4, f - 0.33333334f));
        f6 = Math.min(f6, 1.0f);
        f7 = Math.min(f7, 1.0f);
        f8 = Math.min(f8, 1.0f);
        return PixelColour.createColourRGB(f6, f7, f8);
    }

    private static float HueToRGB(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (6.0f * f3 < 1.0f) {
            return f + (f2 - f) * 6.0f * f3;
        }
        if (2.0f * f3 < 1.0f) {
            return f2;
        }
        if (3.0f * f3 < 2.0f) {
            return f + (f2 - f) * 6.0f * (0.6666667f - f3);
        }
        return f;
    }

    public static void validateColourComponent(String string, int n) {
        if (n < 0 || n >= 256) {
            throw new IllegalArgumentException("Illegal colour value (" + n + ") for '" + string + "' - must be 0.." + 255);
        }
    }

    public static int getRedComponent(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public static int setRedComponent(int n, int n2) {
        PixelColour.validateColourComponent("Red", n2);
        int n3 = n & 0xFFFF;
        return n3 |= n2 << 16;
    }

    public static int getGreenComponet(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static int setGreenComponent(int n, int n2) {
        PixelColour.validateColourComponent("Green", n2);
        int n3 = n & 0xFF00FF;
        return n3 |= n2 << 8;
    }

    public static int getBlueComponent(int n) {
        return n & 0xFF;
    }

    public static int setBlueComponent(int n, int n2) {
        PixelColour.validateColourComponent("Blue", n2);
        int n3 = n & 0xFFFF00;
        return n3 |= n2;
    }
}

