/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.api;

import com.docusign.admin.client.ApiClient;
import com.docusign.admin.client.ApiException;
import com.docusign.admin.client.ApiResponse;
import com.docusign.admin.client.Configuration;
import com.docusign.admin.client.Pair;
import com.docusign.admin.model.AssetGroupAccountClone;
import com.docusign.admin.model.AssetGroupAccountClones;
import com.docusign.admin.model.AssetGroupAccountsResponse;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class ProvisionAssetGroupApi {
    private ApiClient apiClient;

    public ProvisionAssetGroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProvisionAssetGroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AssetGroupAccountClone cloneAssetGroupAccount(UUID organizationId, AssetGroupAccountClone request) throws ApiException {
        ApiResponse<AssetGroupAccountClone> localVarResponse = this.cloneAssetGroupAccountWithHttpInfo(organizationId, request);
        return localVarResponse.getData();
    }

    public ApiResponse<AssetGroupAccountClone> cloneAssetGroupAccountWithHttpInfo(UUID organizationId, AssetGroupAccountClone request) throws ApiException {
        AssetGroupAccountClone localVarPostBody = request;
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling cloneAssetGroupAccount");
        }
        if (request == null) {
            throw new ApiException(400, "Missing the required parameter 'request' when calling cloneAssetGroupAccount");
        }
        String localVarPath = "/v1/organizations/{organizationId}/assetGroups/accountClone".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AssetGroupAccountClone> localVarReturnType = new GenericType<AssetGroupAccountClone>(){};
        AssetGroupAccountClone localVarResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AssetGroupAccountClone>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public AssetGroupAccountClone getAssetGroupAccountClone(UUID organizationId, UUID assetGroupId, UUID assetGroupWorkId) throws ApiException {
        return this.getAssetGroupAccountClone(organizationId, assetGroupId, assetGroupWorkId, null);
    }

    public AssetGroupAccountClone getAssetGroupAccountClone(UUID organizationId, UUID assetGroupId, UUID assetGroupWorkId, GetAssetGroupAccountCloneOptions options) throws ApiException {
        ApiResponse<AssetGroupAccountClone> localVarResponse = this.getAssetGroupAccountCloneWithHttpInfo(organizationId, assetGroupId, assetGroupWorkId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<AssetGroupAccountClone> getAssetGroupAccountCloneWithHttpInfo(UUID organizationId, UUID assetGroupId, UUID assetGroupWorkId, GetAssetGroupAccountCloneOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getAssetGroupAccountClone");
        }
        if (assetGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'assetGroupId' when calling getAssetGroupAccountClone");
        }
        if (assetGroupWorkId == null) {
            throw new ApiException(400, "Missing the required parameter 'assetGroupWorkId' when calling getAssetGroupAccountClone");
        }
        String localVarPath = "/v1/organizations/{organizationId}/assetGroups/{assetGroupId}/accountClones/{assetGroupWorkId}".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString())).replaceAll("\\{assetGroupId\\}", this.apiClient.escapeString(assetGroupId.toString())).replaceAll("\\{assetGroupWorkId\\}", this.apiClient.escapeString(assetGroupWorkId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_details", options.includeDetails));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AssetGroupAccountClone> localVarReturnType = new GenericType<AssetGroupAccountClone>(){};
        AssetGroupAccountClone localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AssetGroupAccountClone>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public AssetGroupAccountClones getAssetGroupAccountClonesByOrgId(UUID organizationId) throws ApiException {
        return this.getAssetGroupAccountClonesByOrgId(organizationId, null);
    }

    public AssetGroupAccountClones getAssetGroupAccountClonesByOrgId(UUID organizationId, GetAssetGroupAccountClonesByOrgIdOptions options) throws ApiException {
        ApiResponse<AssetGroupAccountClones> localVarResponse = this.getAssetGroupAccountClonesByOrgIdWithHttpInfo(organizationId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<AssetGroupAccountClones> getAssetGroupAccountClonesByOrgIdWithHttpInfo(UUID organizationId, GetAssetGroupAccountClonesByOrgIdOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getAssetGroupAccountClonesByOrgId");
        }
        String localVarPath = "/v1/organizations/{organizationId}/assetGroups/accountClones".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("since_updated_date", options.sinceUpdatedDate));
        }
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("include_details", options.includeDetails));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AssetGroupAccountClones> localVarReturnType = new GenericType<AssetGroupAccountClones>(){};
        AssetGroupAccountClones localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AssetGroupAccountClones>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public AssetGroupAccountsResponse getAssetGroupAccounts(UUID organizationId) throws ApiException {
        return this.getAssetGroupAccounts(organizationId, null);
    }

    public AssetGroupAccountsResponse getAssetGroupAccounts(UUID organizationId, GetAssetGroupAccountsOptions options) throws ApiException {
        ApiResponse<AssetGroupAccountsResponse> localVarResponse = this.getAssetGroupAccountsWithHttpInfo(organizationId, options);
        return localVarResponse.getData();
    }

    public ApiResponse<AssetGroupAccountsResponse> getAssetGroupAccountsWithHttpInfo(UUID organizationId, GetAssetGroupAccountsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        if (organizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'organizationId' when calling getAssetGroupAccounts");
        }
        String localVarPath = "/v1/organizations/{organizationId}/assetGroups/accounts".replaceAll("\\{organizationId\\}", this.apiClient.escapeString(organizationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("compliant", options.compliant));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<AssetGroupAccountsResponse> localVarReturnType = new GenericType<AssetGroupAccountsResponse>(){};
        AssetGroupAccountsResponse localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<AssetGroupAccountsResponse>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class GetAssetGroupAccountsOptions {
        private Boolean compliant = null;

        public void setCompliant(Boolean compliant) {
            this.compliant = compliant;
        }

        public Boolean getCompliant() {
            return this.compliant;
        }
    }

    public class GetAssetGroupAccountClonesByOrgIdOptions {
        private String sinceUpdatedDate = null;
        private Boolean includeDetails = null;

        public void setSinceUpdatedDate(String sinceUpdatedDate) {
            this.sinceUpdatedDate = sinceUpdatedDate;
        }

        public String getSinceUpdatedDate() {
            return this.sinceUpdatedDate;
        }

        public void setIncludeDetails(Boolean includeDetails) {
            this.includeDetails = includeDetails;
        }

        public Boolean getIncludeDetails() {
            return this.includeDetails;
        }
    }

    public class GetAssetGroupAccountCloneOptions {
        private Boolean includeDetails = null;

        public void setIncludeDetails(Boolean includeDetails) {
            this.includeDetails = includeDetails;
        }

        public Boolean getIncludeDetails() {
            return this.includeDetails;
        }
    }
}

