/*
 * Decompiled with CFR 0.152.
 */
package com.migcomponents.migbase64;

import java.util.Arrays;

public class Base64 {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] IA = new int[256];

    public static final char[] encodeToChar(byte[] sArr, boolean lineSep) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i2 = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = CA[i2 >>> 18 & 0x3F];
            dArr[d++] = CA[i2 >>> 12 & 0x3F];
            dArr[d++] = CA[i2 >>> 6 & 0x3F];
            dArr[d++] = CA[i2 & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i3 = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = CA[i3 >> 12];
            dArr[dLen - 3] = CA[i3 >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? CA[i3 & 0x3F] : 61;
            dArr[dLen - 1] = 61;
        }
        return dArr;
    }

    public static final byte[] decode(char[] sArr) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (IA[sArr[i2]] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i3 = sLen;
        while (i3 > 1 && IA[sArr[--i3]] <= 0) {
            if (sArr[i3] != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i4 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[sArr[s++]]) >= 0) {
                    i4 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i4 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i4 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i4;
        }
        return dArr;
    }

    public static final byte[] decodeFast(char[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[sArr[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx]] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == '=' ? (sArr[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i2 = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i2 >> 16);
            dArr[d++] = (byte)(i2 >> 8);
            dArr[d++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i3 = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i3 >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static final byte[] encodeToByte(byte[] sArr, boolean lineSep) {
        return Base64.encodeToByte(sArr, 0, sArr != null ? sArr.length : 0, lineSep);
    }

    public static final byte[] encodeToByte(byte[] sArr, int sOff, int sLen, boolean lineSep) {
        if (sArr == null || sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        byte[] dArr = new byte[dLen];
        int s = sOff;
        int d = 0;
        int cc = 0;
        while (s < sOff + eLen) {
            int i2 = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = (byte)CA[i2 >>> 18 & 0x3F];
            dArr[d++] = (byte)CA[i2 >>> 12 & 0x3F];
            dArr[d++] = (byte)CA[i2 >>> 6 & 0x3F];
            dArr[d++] = (byte)CA[i2 & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i3 = (sArr[sOff + eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sOff + sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = (byte)CA[i3 >> 12];
            dArr[dLen - 3] = (byte)CA[i3 >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? (int)CA[i3 & 0x3F] : 61;
            dArr[dLen - 1] = 61;
        }
        return dArr;
    }

    public static final byte[] decode(byte[] sArr) {
        return Base64.decode(sArr, 0, sArr.length);
    }

    public static final byte[] decode(byte[] sArr, int sOff, int sLen) {
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (IA[sArr[sOff + i2] & 0xFF] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i3 = sLen;
        while (i3 > 1 && IA[sArr[sOff + --i3] & 0xFF] <= 0) {
            if (sArr[sOff + i3] != 61) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i4 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[sArr[sOff + s++] & 0xFF]) >= 0) {
                    i4 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i4 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i4 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i4;
        }
        return dArr;
    }

    public static final byte[] decodeFast(byte[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == 61 ? (sArr[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i2 = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i2 >> 16);
            dArr[d++] = (byte)(i2 >> 8);
            dArr[d++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i3 = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i3 >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static final String encodeToString(byte[] sArr, boolean lineSep) {
        return new String(Base64.encodeToChar(sArr, lineSep));
    }

    public static final byte[] decode(String str) {
        int sLen;
        int n = sLen = str != null ? str.length() : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (IA[str.charAt(i2)] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i3 = sLen;
        while (i3 > 1 && IA[str.charAt(--i3)] <= 0) {
            if (str.charAt(i3) != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i4 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[str.charAt(s++)]) >= 0) {
                    i4 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i4 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i4 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i4;
        }
        return dArr;
    }

    public static final byte[] decodeFast(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i2 = IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i2 >> 16);
            dArr[d++] = (byte)(i2 >> 8);
            dArr[d++] = (byte)i2;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i3 = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i3 |= IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i3 >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i2 = 0; i2 < iS; ++i2) {
            Base64.IA[Base64.CA[i2]] = i2;
        }
        Base64.IA[61] = 0;
    }
}

