package com.docusign.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** OSAMRContact. */
public class OSAMRContact implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("title")
  private String title = null;

  /**
   * name.
   *
   * @return OSAMRContact
   */
  public OSAMRContact name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name.
   *
   * @return name
   */
  @Schema(description = "")
  public String getName() {
    return name;
  }

  /** setName. */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * email.
   *
   * @return OSAMRContact
   */
  public OSAMRContact email(String email) {
    this.email = email;
    return this;
  }

  /**
   * Get email.
   *
   * @return email
   */
  @Schema(description = "")
  public String getEmail() {
    return email;
  }

  /** setEmail. */
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * title.
   *
   * @return OSAMRContact
   */
  public OSAMRContact title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title.
   *
   * @return title
   */
  @Schema(description = "")
  public String getTitle() {
    return title;
  }

  /** setTitle. */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OSAMRContact osAMRContact = (OSAMRContact) o;
    return Objects.equals(this.name, osAMRContact.name)
        && Objects.equals(this.email, osAMRContact.email)
        && Objects.equals(this.title, osAMRContact.title);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(name, email, title);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OSAMRContact {\n");

    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
