/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.crud.read.group.GroupExtData;
import com.easy.query.api.lambda.db.DbType;
import com.easy.query.api.lambda.sqlext.SqlFunctions;
import com.easy.query.api.lambda.sqlext.SqlTypes;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import com.easy.query.core.lambda.visitor.SqlValue;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupByReader
extends BaseVisitor {
    private final Map<String, GroupExtData> groupExtDataMap = new HashMap<String, GroupExtData>();
    private GroupExtData cur = new GroupExtData();

    public GroupByReader(List<ParameterExpression> parameters, DbType dbType) {
        super(parameters, dbType);
    }

    public Map<String, GroupExtData> getGroupExtDataMap() {
        return this.groupExtDataMap;
    }

    public GroupExtData getCur() {
        return this.cur;
    }

    public void visit(VariableExpression variable) {
        this.cur = new GroupExtData();
        this.visit(variable.getInit());
        this.groupExtDataMap.put(variable.getName(), this.cur);
        this.cur = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) throw new IllegalExpressionException(methodCall);
            int index = this.parameters.indexOf(parameter);
            String fn = SqlUtil.fieldName(methodCall.getMethod());
            this.putSqlValue(new SqlValue(SqlValue.Type.property, index, fn));
            return;
        } else if (SqlFunctions.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            this.visit(methodCall.getExpr());
            this.matchSqlFunctions(methodCall, this.cur.exprData);
            return;
        } else {
            if (!SqlTypes.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) throw new RuntimeException(methodCall.toString());
            this.visit(methodCall.getExpr());
            this.matchSqlTypes(methodCall, this.cur.exprData);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(fieldSelect.getField().getType())) throw new IllegalExpressionException(fieldSelect);
            int index = this.parameters.indexOf(parameter);
            String fn = SqlUtil.fieldName(fieldSelect.getField());
            this.putSqlValue(new SqlValue(SqlValue.Type.property, index, fn));
            return;
        } else {
            if (ExpressionUtil.hasParameter((Expression)fieldSelect) || ExpressionUtil.isVoid(fieldSelect.getField().getType())) {
                throw new IllegalExpressionException(fieldSelect);
            }
            this.putSqlValue(new SqlValue(fieldSelect.getValue()));
        }
    }

    public void visit(ConstantExpression constant) {
        this.putSqlValue(new SqlValue(constant.getValue()));
    }

    public void visit(ReferenceExpression reference) {
        this.putSqlValue(new SqlValue(reference.getValue()));
    }

    private void putSqlValue(SqlValue sqlValue) {
        this.cur.exprData.append("{}");
        this.cur.sqlValues.add(sqlValue);
    }
}

