/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.crud.read.IAggregation;
import com.easy.query.api.lambda.crud.read.IGroup;
import com.easy.query.api.lambda.crud.read.QueryData;
import com.easy.query.api.lambda.crud.read.group.GroupExtData;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.BaseVisitor;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HavingVisitor
extends BaseVisitor {
    private final QueryData queryData;

    public HavingVisitor(List<ParameterExpression> parameters, QueryData queryData) {
        super(parameters, queryData.getDbType());
        this.queryData = queryData;
    }

    public void visit(LambdaExpression<?> lambda) {
        List parameters = lambda.getParameters();
        HavingVisitor havingVisitor = new HavingVisitor((List<ParameterExpression>)parameters, this.queryData);
        havingVisitor.mesIndex = this.mesIndex;
        lambda.getBody().accept((DeepFindVisitor)havingVisitor);
        this.data.append(havingVisitor.getData());
        this.sqlValue.addAll(havingVisitor.getSqlValue());
        this.mesIndex = havingVisitor.mesIndex;
    }

    public void visit(ParensExpression parensExpression) {
        this.data.append("(");
        this.visit(parensExpression.getExpr());
        this.data.append(")");
    }

    public void visit(UnaryExpression unary) {
        this.data.append(SqlUtil.toSqlOp(unary.getOperatorType()));
        Expression operand = unary.getOperand();
        String sqlOp = SqlUtil.toSqlOp(unary.getOperatorType());
        this.data.append(operand.getKind() == Kind.Parens ? sqlOp : sqlOp + "(");
        this.visit(operand);
        if (operand.getKind() != Kind.Parens) {
            this.data.append(")");
        }
    }

    public void visit(BinaryExpression binary) {
        this.visit(binary.getLeft());
        this.data.append(" ").append(SqlUtil.toSqlOp(binary.getOperatorType())).append(" ");
        this.visit(binary.getRight());
    }

    public void visit(ConstantExpression constant) {
        this.putValue(constant.getValue());
    }

    public void visit(ReferenceExpression reference) {
        this.putValue(reference.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(MethodCallExpression methodCall) {
        if (methodCall.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            if (IAggregation.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
                Method method = methodCall.getMethod();
                List args = methodCall.getArgs();
                String methodName = method.getName();
                this.data.append(methodName).append("(");
                if (args.isEmpty()) {
                    this.data.append("*");
                } else {
                    for (Expression arg : args) {
                        this.visit(arg);
                    }
                }
                this.data.append(")");
                return;
            } else {
                if (!this.parameters.contains(parameter) || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) throw new IllegalExpressionException(methodCall);
                int index = this.parameters.indexOf(parameter);
                this.putField(index, SqlUtil.fieldName(methodCall.getMethod()));
            }
            return;
        } else {
            this.methodCallVisitor(methodCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(FieldSelectExpression fieldSelect) {
        if (fieldSelect.getExpr().getKind() == Kind.Parameter) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            Field field = fieldSelect.getField();
            if (!this.parameters.contains(parameter)) throw new IllegalExpressionException(fieldSelect);
            if (IGroup.class.isAssignableFrom(field.getDeclaringClass()) && field.getName().equals("key")) {
                GroupExtData groupExtData = this.queryData.getGroupExtDataMap().get("key");
                this.putGroupValue(groupExtData);
                return;
            } else {
                int index = this.parameters.indexOf(parameter);
                String fieldName = SqlUtil.fieldName(field);
                this.putField(index, fieldName);
            }
            return;
        } else if (ExpressionUtil.isGroupKey(this.parameters, fieldSelect.getExpr())) {
            Map<String, GroupExtData> gmap = this.queryData.getGroupExtDataMap();
            String fieldName = SqlUtil.fieldName(fieldSelect.getField());
            GroupExtData groupExtData = gmap.get(fieldName);
            this.putGroupValue(groupExtData);
            return;
        } else {
            this.tryPutExprValue(fieldSelect);
        }
    }

    public void visit(ConditionalExpression conditional) {
        Expression condition = conditional.getCondition();
        Expression truePart = conditional.getTruePart();
        Expression falsePart = conditional.getFalsePart();
        Object value = condition.getValue();
        if (value != null) {
            if (((Boolean)value).booleanValue()) {
                this.visit(truePart);
            } else {
                this.visit(falsePart);
            }
        } else {
            this.data.append("IF(");
            this.visit(condition);
            this.data.append(",");
            this.visit(truePart);
            this.data.append(",");
            this.visit(falsePart);
            this.data.append(")");
        }
    }

    private void putGroupValue(GroupExtData groupExtData) {
        String input = groupExtData.exprData.toString();
        Pattern pattern = Pattern.compile("\\{}");
        Matcher matcher = pattern.matcher(input);
        StringBuilder sb = new StringBuilder(input.length());
        int prevEnd = 0;
        while (matcher.find()) {
            sb.append(input.substring(prevEnd, matcher.start()));
            sb.append(this.indexBlock());
            prevEnd = matcher.end();
        }
        if (prevEnd < input.length()) {
            sb.append(input.substring(prevEnd));
        }
        this.data.append((CharSequence)sb);
        this.sqlValue.addAll(groupExtData.sqlValues);
    }
}

