/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.visitor;

import com.easy.query.api.lambda.db.DbType;
import com.easy.query.api.lambda.sqlext.SqlFunctions;
import com.easy.query.api.lambda.sqlext.SqlTypes;
import com.easy.query.core.lambda.exception.IllegalExpressionException;
import com.easy.query.core.lambda.util.ExpressionUtil;
import com.easy.query.core.lambda.util.ParamMatcher;
import com.easy.query.core.lambda.util.SqlUtil;
import com.easy.query.core.lambda.visitor.SqlValue;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class BaseVisitor
extends DeepFindVisitor {
    protected final List<ParameterExpression> parameters;
    protected final DbType dbType;
    protected final StringBuilder data = new StringBuilder();
    protected final List<SqlValue> sqlValue = new ArrayList<SqlValue>();
    protected int mesIndex = 0;

    public BaseVisitor(List<ParameterExpression> parameters, DbType dbType) {
        this.parameters = parameters;
        this.dbType = dbType;
    }

    public String getData() {
        return this.data.toString();
    }

    public List<SqlValue> getSqlValue() {
        return this.sqlValue;
    }

    protected void matchSqlFunctions(MethodCallExpression methodCall, StringBuilder sb) {
        Method callMethod = methodCall.getMethod();
        SqlFunctions.Ext[] exts = (SqlFunctions.Ext[])callMethod.getAnnotationsByType(SqlFunctions.Ext.class);
        if (exts.length == 0) {
            sb.append(callMethod.getName()).append("(");
            List args = methodCall.getArgs();
            for (int i = 0; i < args.size(); ++i) {
                Expression arg = (Expression)args.get(i);
                this.visit(arg);
                if (i >= args.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        } else {
            String function = this.getTargetSqlFuncExt(exts).function();
            this.tryReplace(methodCall, function, sb);
        }
    }

    protected void matchSqlTypes(MethodCallExpression methodCall, StringBuilder sb) {
        Method callMethod = methodCall.getMethod();
        SqlTypes.Ext[] exts = (SqlTypes.Ext[])callMethod.getAnnotationsByType(SqlTypes.Ext.class);
        if (exts.length == 0) {
            sb.append(callMethod.getName());
            if (!methodCall.getArgs().isEmpty()) {
                sb.append("(");
                List args = methodCall.getArgs();
                for (int i = 0; i < args.size(); ++i) {
                    Expression arg = (Expression)args.get(i);
                    this.visit(arg);
                    if (i >= args.size() - 1) continue;
                    sb.append(",");
                }
                sb.append(")");
            }
        } else {
            String type = this.getSqlTypeExtByMethod(exts).type();
            this.tryReplace(methodCall, type, sb);
        }
    }

    protected void tryReplace(MethodCallExpression methodCall, String string, StringBuilder sqlSegment) {
        if (methodCall.getArgs().isEmpty()) {
            sqlSegment.append(string);
        } else if (string.contains("{}")) {
            String[] splitFunc = string.split("\\{}");
            List args = methodCall.getArgs();
            for (int i = 0; i < splitFunc.length; ++i) {
                sqlSegment.append(splitFunc[i]);
                if (i == splitFunc.length - 2 && args.size() >= splitFunc.length) {
                    while (i < args.size()) {
                        this.visit((Expression)args.get(i));
                        if (i < args.size() - 1) {
                            sqlSegment.append(",");
                        }
                        ++i;
                    }
                    sqlSegment.append(splitFunc[splitFunc.length - 1]);
                    continue;
                }
                if (i >= args.size()) continue;
                this.visit((Expression)args.get(i));
            }
        } else if (string.contains("{") && string.contains("}")) {
            List args = methodCall.getArgs();
            List methodParameters = Arrays.stream(methodCall.getMethod().getParameters()).collect(Collectors.toList());
            ParamMatcher match = ExpressionUtil.match(string);
            List<String> functions = match.remainder;
            List<String> params = match.bracesContent;
            for (int i = 0; i < functions.size(); ++i) {
                Parameter targetParam;
                int index;
                sqlSegment.append(functions.get(i));
                if (i >= params.size()) continue;
                String param = params.get(i);
                if (param.chars().allMatch(s -> Character.isDigit(s))) {
                    index = Integer.parseInt(param);
                    targetParam = (Parameter)methodParameters.get(index);
                } else {
                    targetParam = methodParameters.stream().filter(f -> f.getName().equals(param)).findFirst().get();
                    index = methodParameters.indexOf(targetParam);
                }
                if (targetParam.isVarArgs()) {
                    while (index < args.size()) {
                        this.visit((Expression)args.get(index));
                        if (index < args.size() - 1) {
                            sqlSegment.append(",");
                        }
                        ++index;
                    }
                    continue;
                }
                this.visit((Expression)args.get(index));
            }
        } else {
            throw new RuntimeException(methodCall.toString());
        }
    }

    protected SqlTypes.Ext getSqlTypeExtByMethod(SqlTypes.Ext[] exts) {
        List extList = Arrays.stream(exts).filter(f -> f.dbType() == this.dbType).collect(Collectors.toList());
        if (extList.isEmpty()) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + (Object)((Object)this.dbType) + "\n\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\u5e93\u7c7b\u578b\u5bf9\u5e94\u7684\u6ce8\u89e3\n" + Arrays.toString(exts));
        }
        if (extList.size() > 1) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + (Object)((Object)this.dbType) + "\n\u627e\u5230\u4e86\u591a\u4e2a\u5bf9\u5e94\u6570\u636e\u5e93\u7c7b\u578b\u5bf9\u5e94\u7684\u6ce8\u89e3" + Arrays.toString(exts));
        }
        return (SqlTypes.Ext)extList.get(0);
    }

    protected SqlFunctions.Ext getTargetSqlFuncExt(SqlFunctions.Ext[] exts) {
        List extList = Arrays.stream(exts).filter(f -> f.dbType() == this.dbType).collect(Collectors.toList());
        if (extList.isEmpty()) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + (Object)((Object)this.dbType) + "\n\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\u5e93\u7c7b\u578b\u5bf9\u5e94\u7684\u6ce8\u89e3\n" + Arrays.toString(exts));
        }
        if (extList.size() > 1) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b:" + (Object)((Object)this.dbType) + "\n\u627e\u5230\u4e86\u591a\u4e2a\u5bf9\u5e94\u6570\u636e\u5e93\u7c7b\u578b\u5bf9\u5e94\u7684\u6ce8\u89e3" + Arrays.toString(exts));
        }
        return (SqlFunctions.Ext)extList.get(0);
    }

    protected String indexBlock() {
        return "{" + this.mesIndex++ + "}";
    }

    protected void cleanIndexBlock() {
        this.mesIndex = 0;
    }

    protected void putValue(Object value) {
        this.data.append(this.indexBlock());
        this.sqlValue.add(new SqlValue(value));
    }

    protected void putField(int index, String fieldName) {
        this.data.append(this.indexBlock());
        this.sqlValue.add(new SqlValue(SqlValue.Type.property, index, fieldName));
    }

    protected void tryPutExprValue(MethodCallExpression methodCall) {
        if (ExpressionUtil.hasParameter((Expression)methodCall) || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) {
            throw new IllegalExpressionException(methodCall);
        }
        this.putValue(methodCall.getValue());
    }

    protected void tryPutExprValue(FieldSelectExpression fieldSelect) {
        if (ExpressionUtil.hasParameter((Expression)fieldSelect) || ExpressionUtil.isVoid(fieldSelect.getField().getType())) {
            throw new IllegalExpressionException(fieldSelect);
        }
        this.putValue(fieldSelect.getValue());
    }

    protected void methodCallVisitor(MethodCallExpression methodCall) {
        block94: {
            Class<?> declaringClass;
            Method callMethod;
            block100: {
                block99: {
                    block98: {
                        block97: {
                            block96: {
                                block95: {
                                    block93: {
                                        callMethod = methodCall.getMethod();
                                        declaringClass = callMethod.getDeclaringClass();
                                        if (!ExpressionUtil.isEquals(callMethod)) break block93;
                                        this.visit(methodCall.getExpr());
                                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.EQ)).append(" ");
                                        for (Expression arg : methodCall.getArgs()) {
                                            this.visit(arg);
                                        }
                                        break block94;
                                    }
                                    if (!SqlFunctions.class.isAssignableFrom(declaringClass)) break block95;
                                    this.visit(methodCall.getExpr());
                                    this.matchSqlFunctions(methodCall, this.data);
                                    break block94;
                                }
                                if (!SqlTypes.class.isAssignableFrom(declaringClass)) break block96;
                                this.visit(methodCall.getExpr());
                                this.matchSqlTypes(methodCall, this.data);
                                break block94;
                            }
                            if (!Iterable.class.isAssignableFrom(declaringClass)) break block97;
                            Iterable iterable = (Iterable)methodCall.getExpr().getValue();
                            Iterator iterator = iterable.iterator();
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            this.data.append(" IN ");
                            this.data.append("(");
                            for (Object o : iterable) {
                                this.data.append(this.indexBlock());
                                this.sqlValue.add(new SqlValue(o));
                                if (!iterator.hasNext()) continue;
                                this.data.append(",");
                            }
                            this.data.append(")");
                            break block94;
                        }
                        if (!String.class.isAssignableFrom(declaringClass)) break block98;
                        switch (callMethod.getName()) {
                            case "contains": {
                                this.visit(methodCall.getExpr());
                                this.data.append(" LIKE ").append("CONCAT('%',");
                                for (Expression arg : methodCall.getArgs()) {
                                    this.visit(arg);
                                }
                                this.data.append(",'%') ");
                                break;
                            }
                            case "startsWith": {
                                this.visit(methodCall.getExpr());
                                this.data.append(" LIKE ").append("CONCAT(");
                                for (Expression arg : methodCall.getArgs()) {
                                    this.visit(arg);
                                }
                                this.data.append(",'%') ");
                                break;
                            }
                            case "endsWith": {
                                this.visit(methodCall.getExpr());
                                this.data.append(" LIKE ").append("CONCAT('%',");
                                for (Expression arg : methodCall.getArgs()) {
                                    this.visit(arg);
                                }
                                this.data.append(") ");
                                break;
                            }
                            default: {
                                this.tryPutExprValue(methodCall);
                                break;
                            }
                        }
                        break block94;
                    }
                    if (!BigDecimal.class.isAssignableFrom(declaringClass) && !BigInteger.class.isAssignableFrom(declaringClass)) break block99;
                    switch (callMethod.getName()) {
                        case "add": {
                            this.visit(methodCall.getExpr());
                            this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.PLUS)).append(" ");
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            break block94;
                        }
                        case "subtract": {
                            this.visit(methodCall.getExpr());
                            this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.MINUS)).append(" ");
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            break block94;
                        }
                        case "multiply": {
                            this.visit(methodCall.getExpr());
                            this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.MUL)).append(" ");
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            break block94;
                        }
                        case "divide": {
                            this.visit(methodCall.getExpr());
                            this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.DIV)).append(" ");
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            break block94;
                        }
                        case "remainder": {
                            this.visit(methodCall.getExpr());
                            this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.MOD)).append(" ");
                            for (Expression arg : methodCall.getArgs()) {
                                this.visit(arg);
                            }
                            break block94;
                        }
                        default: {
                            this.tryPutExprValue(methodCall);
                        }
                    }
                    break block94;
                }
                if (!Temporal.class.isAssignableFrom(declaringClass)) break block100;
                switch (callMethod.getName()) {
                    case "now": {
                        this.visit(methodCall.getExpr());
                        if (LocalDateTime.class.isAssignableFrom(declaringClass)) {
                            this.data.append("NOW()");
                            break;
                        }
                        if (LocalDate.class.isAssignableFrom(declaringClass)) {
                            this.data.append("CURDATE()");
                            break;
                        }
                        break block94;
                    }
                    case "plus": {
                        this.visit(methodCall.getExpr());
                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.PLUS)).append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        break block94;
                    }
                    case "minus": {
                        this.visit(methodCall.getExpr());
                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.MINUS)).append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        break block94;
                    }
                    case "isAfter": {
                        this.visit(methodCall.getExpr());
                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.GT)).append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        break block94;
                    }
                    case "isBefore": {
                        this.visit(methodCall.getExpr());
                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.LT)).append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        break block94;
                    }
                    case "isEqual": {
                        this.visit(methodCall.getExpr());
                        this.data.append(" ").append(SqlUtil.toSqlOp(OperatorType.EQ)).append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        break block94;
                    }
                    case "of": {
                        if (LocalTime.class.isAssignableFrom(declaringClass)) {
                            this.data.append("MAKETIME(");
                            List args = methodCall.getArgs();
                            for (int i = 0; i < args.size(); ++i) {
                                Expression arg = (Expression)args.get(i);
                                this.visit(arg);
                                if (i >= args.size() - 1) continue;
                                this.data.append(",");
                            }
                            this.data.append(")");
                            break;
                        }
                        break block94;
                    }
                    case "ofYearDay": {
                        this.visit(methodCall.getExpr());
                        if (LocalDate.class.isAssignableFrom(declaringClass)) {
                            this.data.append("MAKEDATE(");
                            List args = methodCall.getArgs();
                            for (int i = 0; i < args.size(); ++i) {
                                Expression arg = (Expression)args.get(i);
                                this.visit(arg);
                                if (i >= args.size() - 1) continue;
                                this.data.append(",");
                            }
                            this.data.append(")");
                            break;
                        }
                        break block94;
                    }
                    default: {
                        this.tryPutExprValue(methodCall);
                    }
                }
                break block94;
            }
            if (TemporalAmount.class.isAssignableFrom(declaringClass)) {
                switch (callMethod.getName()) {
                    case "ofYears": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("YEAR");
                        break;
                    }
                    case "ofMonths": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("MONTH");
                        break;
                    }
                    case "ofWeeks": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("WEEK");
                        break;
                    }
                    case "ofDays": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("DAY");
                        break;
                    }
                    case "ofHours": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("HOUR");
                        break;
                    }
                    case "ofMinutes": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("MINUTE");
                        break;
                    }
                    case "ofSeconds": {
                        this.visit(methodCall.getExpr());
                        this.data.append("INTERVAL").append(" ");
                        for (Expression arg : methodCall.getArgs()) {
                            this.visit(arg);
                        }
                        this.data.append(" ").append("SECOND");
                        break;
                    }
                    default: {
                        this.tryPutExprValue(methodCall);
                        break;
                    }
                }
            } else {
                this.tryPutExprValue(methodCall);
            }
        }
    }
}

