/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.util;

import com.easy.query.core.annotation.Column;
import com.easy.query.core.util.EasyStringUtil;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SqlUtil {
    public static String fieldName(Method method) {
        try {
            String fieldName = method.getName();
            fieldName = fieldName.startsWith("get") || fieldName.startsWith("set") ? fieldName.substring(3) : fieldName.substring(2);
            Field field = method.getDeclaringClass().getDeclaredField(EasyStringUtil.toLowerCaseFirstOne((String)fieldName));
            return SqlUtil.fieldName(field);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fieldName(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column == null || column.value().isEmpty()) {
            return field.getName();
        }
        return column.value();
    }

    public static String toSqlOp(OperatorType operatorType) {
        switch (operatorType) {
            case NOT: {
                return "NOT";
            }
            case AND: {
                return "AND";
            }
            case OR: {
                return "OR";
            }
            case EQ: {
                return "=";
            }
            case NE: {
                return "<>";
            }
        }
        return operatorType.getOperator();
    }
}

