/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.util;

import com.easy.query.api.lambda.crud.read.group.IGroup;
import com.easy.query.core.lambda.util.ParamMatcher;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionUtil {
    public static boolean isVoid(Class<?> c) {
        return c == Void.TYPE || c == Void.class;
    }

    public static boolean isTableProperty(List<ParameterExpression> parameters, Expression expression) {
        if (expression.getKind() == Kind.MethodCall) {
            MethodCallExpression methodCall = (MethodCallExpression)expression;
            if (!methodCall.inParameters(parameters) || !methodCall.getArgs().isEmpty() || ExpressionUtil.isVoid(methodCall.getMethod().getReturnType())) {
                return false;
            }
            String methodName = methodCall.getMethod().getName();
            return !methodName.equals("hashCode") && !methodName.equals("clone") && !methodName.equals("toString") && !methodName.equals("finalize");
        }
        if (expression.getKind() == Kind.FieldSelect) {
            FieldSelectExpression fieldSelect = (FieldSelectExpression)expression;
            return fieldSelect.inParameters(parameters);
        }
        return false;
    }

    public static boolean isGroupKey(List<ParameterExpression> parameters, Expression expression) {
        if (expression instanceof FieldSelectExpression) {
            FieldSelectExpression fieldSelect = (FieldSelectExpression)expression;
            Field field = fieldSelect.getField();
            return fieldSelect.inParameters(parameters) && IGroup.class.isAssignableFrom(field.getDeclaringClass()) && field.getName().equals("key");
        }
        return false;
    }

    public static boolean isEquals(Method method) {
        return method.getName().equals("equals") && method.getParameterCount() == 1 && method.getParameters()[0].getType() == Object.class;
    }

    public static boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isStaticComparatorMethod(Method method) {
        return ExpressionUtil.isStaticMethod(method) && method.getParameterCount() == 2 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class);
    }

    public static boolean isStaticNullCheckMethod(Method method) {
        return ExpressionUtil.isStaticMethod(method) && method.getParameterCount() == 1 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class);
    }

    public static boolean isStaticOperationMethod(Method method) {
        return ExpressionUtil.isStaticMethod(method) && method.getParameterCount() == 2 && method.getReturnType() != Void.TYPE && method.getReturnType() != Void.class;
    }

    public static boolean hasParameter(Expression expression) {
        final AtomicBoolean flag = new AtomicBoolean(false);
        expression.accept(new DeepFindVisitor(){

            public void visit(ParameterExpression parameterExpression) {
                flag.set(true);
            }
        });
        return flag.get();
    }

    public static ParamMatcher match(String input) {
        ParamMatcher paramMatcher = new ParamMatcher();
        List<String> bracesContent = paramMatcher.bracesContent;
        List<String> remainder = paramMatcher.remainder;
        Pattern pattern = Pattern.compile("\\{([^}]+)}");
        Matcher matcher = pattern.matcher(input);
        int lastIndex = 0;
        while (matcher.find()) {
            if (lastIndex < matcher.start()) {
                remainder.add(input.substring(lastIndex, matcher.start()));
            }
            bracesContent.add(matcher.group(1));
            lastIndex = matcher.end();
        }
        if (lastIndex < input.length()) {
            remainder.add(input.substring(lastIndex));
        }
        return paramMatcher;
    }
}

