/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.lambda.client;

import com.easy.query.api.lambda.crud.create.LInsert;
import com.easy.query.api.lambda.crud.delete.LDelete;
import com.easy.query.api.lambda.crud.read.LQuery;
import com.easy.query.api.lambda.crud.read.LQuery10;
import com.easy.query.api.lambda.crud.read.LQuery2;
import com.easy.query.api.lambda.crud.read.LQuery3;
import com.easy.query.api.lambda.crud.read.LQuery4;
import com.easy.query.api.lambda.crud.read.LQuery5;
import com.easy.query.api.lambda.crud.read.LQuery6;
import com.easy.query.api.lambda.crud.read.LQuery7;
import com.easy.query.api.lambda.crud.read.LQuery8;
import com.easy.query.api.lambda.crud.read.LQuery9;
import com.easy.query.api.lambda.crud.update.LUpdate;
import com.easy.query.api.lambda.db.DbType;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.lambda.common.UnsafeFastBean;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.h2.expression.H2ExpressionFactory;
import com.easy.query.mysql.expression.MySQLQuerySQLExpression;
import com.easy.query.oracle.expression.OracleExpressionFactory;
import java.lang.invoke.MethodHandles;

public class EasyLambdaQueryClient {
    private final EasyQueryClient easyQueryClient;
    private final DbType dbType;

    public EasyQueryClient getEasyQueryClient() {
        return this.easyQueryClient;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public EasyLambdaQueryClient(EasyQueryClient easyQueryClient, MethodHandles.Lookup lookup) {
        this.easyQueryClient = easyQueryClient;
        this.dbType = this.getDbTypeByEasyQueryClient(easyQueryClient);
        this.unsafeFastBean(lookup);
    }

    private void unsafeFastBean(MethodHandles.Lookup lookup) {
        EasyBeanUtil.FAST_BEAN_FUNCTION = c -> new UnsafeFastBean((Class<?>)c, lookup);
    }

    private DbType getDbTypeByEasyQueryClient(EasyQueryClient easyQueryClient) {
        ExpressionFactory service = (ExpressionFactory)easyQueryClient.getRuntimeContext().getService(ExpressionFactory.class);
        if (service instanceof MySQLQuerySQLExpression) {
            return DbType.MySQL;
        }
        if (service instanceof OracleExpressionFactory) {
            return DbType.Oracle;
        }
        if (service instanceof H2ExpressionFactory) {
            return DbType.H2;
        }
        return DbType.MySQL;
    }

    public Transaction beginTransaction() {
        return this.easyQueryClient.beginTransaction();
    }

    public Transaction beginTransaction(int isolationLevel) {
        return this.easyQueryClient.beginTransaction(Integer.valueOf(isolationLevel));
    }

    public <T> LInsert<T> insertable(T entity) {
        return new LInsert(this.easyQueryClient.insertable(entity), this.dbType);
    }

    public <T> LDelete<T> deletable(Class<T> c) {
        return new LDelete(this.easyQueryClient.deletable(c), this.dbType);
    }

    public <T> LUpdate<T> updatable(Class<T> c) {
        return new LUpdate(this.easyQueryClient.updatable(c), this.dbType);
    }

    public <T> LQuery<T> queryable(Class<T> c) {
        return new LQuery(this.easyQueryClient.queryable(c), this.dbType);
    }

    public <T1, T2> LQuery2<T1, T2> queryable(Class<T1> c1, Class<T2> c2) {
        return new LQuery2(this.easyQueryClient.queryable(c1).from(c2), this.dbType);
    }

    public <T1, T2, T3> LQuery3<T1, T2, T3> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3) {
        return new LQuery3(this.easyQueryClient.queryable(c1).from(c2, c3), this.dbType);
    }

    public <T1, T2, T3, T4> LQuery4<T1, T2, T3, T4> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4) {
        return new LQuery4(this.easyQueryClient.queryable(c1).from(c2, c3, c4), this.dbType);
    }

    public <T1, T2, T3, T4, T5> LQuery5<T1, T2, T3, T4, T5> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5) {
        return new LQuery5(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5), this.dbType);
    }

    public <T1, T2, T3, T4, T5, T6> LQuery6<T1, T2, T3, T4, T5, T6> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5, Class<T6> c6) {
        return new LQuery6(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5, c6), this.dbType);
    }

    public <T1, T2, T3, T4, T5, T6, T7> LQuery7<T1, T2, T3, T4, T5, T6, T7> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5, Class<T6> c6, Class<T7> c7) {
        return new LQuery7(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5, c6, c7), this.dbType);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> LQuery8<T1, T2, T3, T4, T5, T6, T7, T8> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5, Class<T6> c6, Class<T7> c7, Class<T8> c8) {
        return new LQuery8(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5, c6, c7, c8), this.dbType);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> LQuery9<T1, T2, T3, T4, T5, T6, T7, T8, T9> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5, Class<T6> c6, Class<T7> c7, Class<T8> c8, Class<T9> c9) {
        return new LQuery9(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5, c6, c7, c8, c9), this.dbType);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> LQuery10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> queryable(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4, Class<T5> c5, Class<T6> c6, Class<T7> c7, Class<T8> c8, Class<T9> c9, Class<T10> c10) {
        return new LQuery10(this.easyQueryClient.queryable(c1).from(c2, c3, c4, c5, c6, c7, c8, c9, c10), this.dbType);
    }
}

