/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.lambda.common;

import com.easy.query.core.common.bean.DefaultFastBean;
import com.easy.query.core.common.bean.FastBeanProperty;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.PropertyVoidSetter;
import com.easy.query.core.util.EasyClassUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import sun.misc.Unsafe;

public class UnsafeFastBean
extends DefaultFastBean {
    private static final Unsafe unsafe;
    private final Class<?> beanClass;
    private final boolean isAnonymousClass;
    private final MethodHandles.Lookup lookup;

    public UnsafeFastBean(Class<?> beanClass, MethodHandles.Lookup lookup) {
        super(beanClass);
        this.beanClass = beanClass;
        this.lookup = lookup;
        this.isAnonymousClass = beanClass.isAnonymousClass();
    }

    public Supplier<Object> getBeanConstructorCreator() {
        if (this.isAnonymousClass) {
            return () -> {
                try {
                    return unsafe.allocateInstance(this.beanClass);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return super.getBeanConstructorCreator();
    }

    public Property<Object, ?> getBeanGetter(FastBeanProperty prop) {
        if (this.isAnonymousClass) {
            Class propertyType = prop.getPropertyType();
            Method readMethod = prop.getReadMethod();
            String getFunName = readMethod.getName();
            MethodType methodType = MethodType.methodType(propertyType, this.beanClass);
            try {
                MethodHandle virtual = this.lookup.findVirtual(this.beanClass, getFunName, MethodType.methodType(propertyType));
                CallSite site = LambdaMetafactory.altMetafactory(this.lookup, "apply", MethodType.methodType(Property.class), methodType.erase().generic(), virtual, methodType, 1);
                return site.getTarget().invokeExact();
            }
            catch (Throwable e) {
                throw new EasyQueryException(e);
            }
        }
        return super.getBeanGetter(prop);
    }

    public PropertySetterCaller<Object> getBeanSetter(FastBeanProperty prop) {
        if (this.isAnonymousClass) {
            Class propertyType = prop.getPropertyType();
            Method writeMethod = EasyClassUtil.getWriteMethodNotNull((FastBeanProperty)prop, this.beanClass);
            MethodType setter = MethodType.methodType(writeMethod.getReturnType(), propertyType);
            Class lambdaPropertyType = EasyClassUtil.getObjectTypeWhenPrimitive((Class)propertyType);
            String getFunName = writeMethod.getName();
            try {
                MethodType instantiatedMethodType = MethodType.methodType(Void.TYPE, this.beanClass, lambdaPropertyType);
                MethodHandle target = this.lookup.findVirtual(this.beanClass, getFunName, setter);
                MethodType samMethodType = MethodType.methodType(Void.TYPE, Object.class, Object.class);
                CallSite site = LambdaMetafactory.metafactory(this.lookup, "apply", MethodType.methodType(PropertyVoidSetter.class), samMethodType, target, instantiatedMethodType);
                PropertyVoidSetter objectPropertyVoidSetter = site.getTarget().invokeExact();
                return (arg_0, arg_1) -> ((PropertyVoidSetter)objectPropertyVoidSetter).apply(arg_0, arg_1);
            }
            catch (Throwable e) {
                throw new EasyQueryException(e);
            }
        }
        return super.getBeanSetter(prop);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

