/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.facecto.code.excel.entity.ExcelData;
import com.facecto.code.excel.strategy.ContentStyle;
import com.facecto.code.excel.strategy.ExcelStyle;
import com.facecto.code.excel.strategy.HeadStyle;
import com.facecto.code.excel.strategy.MergeStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.ClassPathResource;

public class ExcelWrite {
    public void writeWithTemplateByWeb(Object headData, Object contentData, MergeStrategy mergeStrategy, HorizontalCellStyleStrategy horizontalCellStyleStrategy, String outFileName, String templateFileName, HttpServletResponse response) throws IOException {
        response = this.setResponse(outFileName, response);
        ClassPathResource classPathResource = new ClassPathResource(templateFileName);
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(classPathResource.getInputStream());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        xssfWorkbook.write((OutputStream)outStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outStream.toByteArray());
        this.excelWriterWithTemplate(headData, contentData, mergeStrategy, horizontalCellStyleStrategy, outFileName, templateFileName, true, response, inputStream);
    }

    public void writeWithTemplate(Object headData, Object contentData, MergeStrategy mergeStrategy, HorizontalCellStyleStrategy horizontalCellStyleStrategy, String outFileName, String templateFileName) throws IOException {
        this.excelWriterWithTemplate(headData, contentData, mergeStrategy, horizontalCellStyleStrategy, outFileName, templateFileName, false, null, null);
    }

    public <X, Y> void writeWithTemplateMultiSheetByWeb(ExcelData<X, Y> excelData, String outFileName, String templateFileName, HttpServletResponse response) throws IOException {
        response = this.setResponse(outFileName, response);
        ClassPathResource classPathResource = new ClassPathResource(templateFileName);
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(classPathResource.getInputStream());
        ByteArrayInputStream inputStream = this.getByteArrayInputStream(excelData, xssfWorkbook);
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate((InputStream)inputStream).build();
        this.writeExcelSheet(excelData, excelWriter);
    }

    public <X, Y> void writeWithTemplateMultiSheet(ExcelData<X, Y> excelData, String outFileName, String templateFileName) throws IOException {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook(templateFileName);
        ByteArrayInputStream inputStream = this.getByteArrayInputStream(excelData, xssfWorkbook);
        ExcelWriter excelWriter = EasyExcel.write((String)outFileName).withTemplate((InputStream)inputStream).build();
        this.writeExcelSheet(excelData, excelWriter);
    }

    private <X, Y> ByteArrayInputStream getByteArrayInputStream(ExcelData<X, Y> excelData, XSSFWorkbook xssfWorkbook) throws IOException {
        int i;
        for (i = 0; i < excelData.getSheetHeadList().size() - 1; ++i) {
            xssfWorkbook.cloneSheet(0);
        }
        for (i = 0; i < xssfWorkbook.getNumberOfSheets(); ++i) {
            String sheetName = i + 1 + excelData.getSheetNameList().get(i).toString();
            xssfWorkbook.setSheetName(i, sheetName);
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        xssfWorkbook.write((OutputStream)outStream);
        return new ByteArrayInputStream(outStream.toByteArray());
    }

    private <X, Y> void writeExcelSheet(ExcelData<X, Y> excelData, ExcelWriter excelWriter) {
        FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
        for (int i = 0; i < excelData.getSheetHeadList().size(); ++i) {
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)i).build();
            excelWriter.fill(excelData.getSheetHeadList().get(i), writeSheet);
            excelWriter.fill(excelData.getSheetBodyList().get(i).getList(), fillConfig, writeSheet);
        }
        excelWriter.finish();
    }

    private HttpServletResponse setResponse(String outFileName, HttpServletResponse response) {
        response.setHeader("Content-disposition", "attachment; filename=" + this.formatFileName(outFileName));
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
        return response;
    }

    private void excelWriterWithTemplate(Object headData, Object contentData, MergeStrategy mergeStrategy, HorizontalCellStyleStrategy horizontalCellStyleStrategy, String outFileName, String templateFileName, boolean hasWeb, HttpServletResponse response, InputStream inputStream) throws IOException {
        ExcelWriter excelWriter = null;
        excelWriter = hasWeb && inputStream != null ? ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(inputStream).registerWriteHandler((WriteHandler)mergeStrategy)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).build() : ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((String)this.formatFileName(outFileName)).withTemplate(templateFileName).registerWriteHandler((WriteHandler)mergeStrategy)).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        if (headData != null) {
            excelWriter.fill(headData, writeSheet);
        }
        if (contentData != null) {
            excelWriter.fill(contentData, writeSheet);
        }
        excelWriter.finish();
    }

    private HorizontalCellStyleStrategy getDefaultHorizontalCellStyleStrategy(ExcelStyle style) {
        HeadStyle headStyle = style.getHeadStyle();
        ContentStyle contentStyle = style.getContentStyle();
        WriteFont headFont = new WriteFont();
        headFont.setFontHeightInPoints(headStyle.getFontSize());
        headFont.setFontName(headStyle.getFontName());
        headFont.setBold(headStyle.getHasBold());
        WriteFont contentFont = new WriteFont();
        contentFont.setFontHeightInPoints(contentStyle.getFontSize());
        contentFont.setFontName(contentStyle.getFontName());
        contentFont.setBold(contentStyle.getHasBold());
        WriteCellStyle headStyle1 = new WriteCellStyle();
        headStyle1.setFillForegroundColor(Short.valueOf(headStyle.getForegroundColor().getIndex()));
        headStyle1.setWriteFont(headFont);
        headStyle1.setHorizontalAlignment(headStyle.getHorizontalAlignment());
        headStyle1.setVerticalAlignment(headStyle.getVerticalAlignment());
        WriteCellStyle contentStyle1 = new WriteCellStyle();
        contentStyle1.setFillForegroundColor(Short.valueOf(contentStyle.getForegroundColor().getIndex()));
        contentStyle1.setHorizontalAlignment(contentStyle.getHorizontalAlignment());
        contentStyle1.setVerticalAlignment(contentStyle.getVerticalAlignment());
        contentStyle1.setWriteFont(contentFont);
        return new HorizontalCellStyleStrategy(headStyle1, contentStyle1);
    }

    private String formatFileName(String filename) {
        if (filename.endsWith(".xlsx")) {
            return filename;
        }
        return filename + ".xlsx";
    }
}

