/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.excel.strategy;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import com.facecto.code.excel.strategy.RowMergeColumnRole;
import com.facecto.code.excel.strategy.RowMergeRole;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class MergeStrategy
extends AbstractMergeStrategy {
    private RowMergeRole rowMergeRole;
    private Sheet sheet;
    private Integer skipRow = 0;

    public MergeStrategy(RowMergeRole rowMergeRole) {
        this.rowMergeRole = rowMergeRole;
        this.skipRow = rowMergeRole.getRowSkip();
    }

    private void mergeRow(Integer columnIndex) {
        Integer rowCurrent = this.rowMergeRole.getRowSkip();
        for (RowMergeColumnRole role : this.rowMergeRole.getList()) {
            if (columnIndex < role.getColumnStart() || columnIndex > role.getColumnEnd()) continue;
            for (Integer count : role.getRowMerges()) {
                if (count > 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(rowCurrent.intValue(), rowCurrent + count - 1, columnIndex.intValue(), columnIndex.intValue());
                    this.sheet.addMergedRegionUnsafe(cellRangeAddress);
                    rowCurrent = rowCurrent + count;
                    continue;
                }
                rowCurrent = rowCurrent + count;
            }
        }
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer integer) {
        this.sheet = sheet;
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        Row row = cell.getRow();
        if (rowIndex == this.skipRow) {
            this.mergeRow(cell.getColumnIndex());
        }
    }
}

