/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.base;

import com.facecto.code.base.enums.ResultMessage;
import com.facecto.code.base.enums.ResultStatus;
import java.io.Serializable;

public class CodeResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private T data;
    private Integer code;
    private String message;
    private ResultStatus status;

    public CodeResult() {
        this.code = 0;
        this.message = ResultMessage.SYSTEM_OK.getValue();
        this.status = ResultStatus.SUCCESS;
    }

    private CodeResult(Integer code, String message, ResultStatus status) {
        this.code = code;
        this.message = message;
        this.status = status;
    }

    private CodeResult(Integer code, String message, ResultStatus status, T data) {
        this.code = code;
        this.message = message;
        this.status = status;
        this.data = data;
    }

    public static <T> CodeResult<T> error() {
        return new CodeResult<T>(500, ResultMessage.SYSTEM_ERROR.getValue(), ResultStatus.FAIL);
    }

    public static <T> CodeResult<T> error(String message) {
        return new CodeResult<T>(500, message, ResultStatus.FAIL);
    }

    public static <T> CodeResult<T> error(int code, String message) {
        return new CodeResult<T>(code, message, ResultStatus.FAIL);
    }

    public static <T> CodeResult<T> ok() {
        return new CodeResult<T>();
    }

    public static <T> CodeResult<T> ok(String message) {
        return new CodeResult<T>(0, message, ResultStatus.SUCCESS);
    }

    public static <T> CodeResult<T> ok(String message, T data) {
        return new CodeResult<T>(0, message, ResultStatus.SUCCESS, data);
    }

    public static <T> CodeResult<T> okx(T data) {
        return new CodeResult<T>(0, ResultMessage.SYSTEM_SUCCESS.getValue(), ResultStatus.SUCCESS, data);
    }

    public T getData() {
        return this.data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeResult)) {
            return false;
        }
        CodeResult other = (CodeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ResultStatus this$status = this.getStatus();
        ResultStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ResultStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "CodeResult(data=" + this.getData() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public CodeResult(T data, Integer code, String message, ResultStatus status) {
        this.data = data;
        this.code = code;
        this.message = message;
        this.status = status;
    }
}

