/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.base;

import com.facecto.code.base.enums.ResultMessageEnum;
import com.facecto.code.base.enums.ResultStatusEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeResult<T>
implements Serializable {
    private static final long serialVersionUID = 6374486752803150412L;
    private T data;
    private Integer code;
    private String message;
    private ResultStatusEnum status;
    private Long total;
    private Long page;
    private Long pageSize;

    public CodeResult() {
        this.code = 0;
        this.message = ResultMessageEnum.SYSTEM_OK.getValue();
        this.status = ResultStatusEnum.SUCCESS;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    private CodeResult(Integer code, String message, ResultStatusEnum status) {
        this.code = code;
        this.message = message;
        this.status = status;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    private CodeResult(Integer code, String message, ResultStatusEnum status, T data) {
        this.code = code;
        this.message = message;
        this.status = status;
        this.data = data;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    private CodeResult(Integer code, String message, ResultStatusEnum status, T data, long total, long page, long pageSize) {
        this.code = code;
        this.message = message;
        this.status = status;
        this.data = data;
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
    }

    public static <T> CodeResult<T> error() {
        return new CodeResult<T>(500, ResultMessageEnum.SYSTEM_ERROR.getValue(), ResultStatusEnum.FAIL);
    }

    public static <T> CodeResult<T> error(String message) {
        return new CodeResult<T>(500, message, ResultStatusEnum.FAIL);
    }

    public static <T> CodeResult<T> error(int code, String message) {
        return new CodeResult<T>(code, message, ResultStatusEnum.FAIL);
    }

    public static <T> CodeResult<T> ok() {
        return new CodeResult<T>();
    }

    public static <T> CodeResult<T> ok(String message) {
        return new CodeResult<T>(0, message, ResultStatusEnum.SUCCESS);
    }

    public static <T> CodeResult<T> ok(String message, T data) {
        return new CodeResult<T>(0, message, ResultStatusEnum.SUCCESS, data);
    }

    public static <T> CodeResult<T> ok(String message, T data, long total, long page, long pageSize) {
        return new CodeResult<T>(0, message, ResultStatusEnum.SUCCESS, data, total, page, pageSize);
    }

    public static <T> CodeResult<T> okx(T data) {
        return new CodeResult<T>(0, ResultMessageEnum.SYSTEM_SUCCESS.getValue(), ResultStatusEnum.SUCCESS, data);
    }

    public T getData() {
        return this.data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public ResultStatusEnum getStatus() {
        return this.status;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(ResultStatusEnum status) {
        this.status = status;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeResult)) {
            return false;
        }
        CodeResult other = (CodeResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Long this$page = this.getPage();
        Long other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Long this$pageSize = this.getPageSize();
        Long other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ResultStatusEnum this$status = this.getStatus();
        ResultStatusEnum other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Long $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Long $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ResultStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "CodeResult(data=" + this.getData() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", status=" + (Object)((Object)this.getStatus()) + ", total=" + this.getTotal() + ", page=" + this.getPage() + ", pageSize=" + this.getPageSize() + ")";
    }

    public CodeResult(T data, Integer code, String message, ResultStatusEnum status, Long total, Long page, Long pageSize) {
        this.data = data;
        this.code = code;
        this.message = message;
        this.status = status;
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
    }
}

