/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.base.handler;

import com.facecto.code.base.CodeException;
import com.facecto.code.base.CodeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class CodeExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CodeExceptionHandler.class);

    @ExceptionHandler(value={IllegalArgumentException.class})
    public CodeResult handleIllegalArgumentException(IllegalArgumentException e) {
        log.error("Params error.");
        return CodeResult.error(500, "Params error.");
    }

    @ExceptionHandler(value={SecurityException.class})
    public CodeResult handleSecurityException(SecurityException e) {
        log.error("No access allowed.");
        return CodeResult.error(500, "No access allowed.");
    }

    @ExceptionHandler(value={NullPointerException.class})
    public CodeResult handleNullPointerException(NullPointerException e) {
        log.error("Null pointer exception.");
        return CodeResult.error(500, "Null pointer exception.");
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public CodeResult handlerNoFoundException(NoHandlerFoundException e) {
        log.error(e.getMessage(), (Throwable)e);
        return CodeResult.error(404, "Corresponding resource not found.");
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public CodeResult handlerHttpMediaTypeNotSupportedException(HttpMediaTypeNotSupportedException e) {
        log.error("Request type is not supported.");
        return CodeResult.error(500, "Request type is not supported.");
    }

    @ExceptionHandler(value={CodeException.class})
    public CodeResult handleCodeException(CodeException e) {
        return CodeResult.error(e.getCode(), e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public CodeResult handleRuntimeException(RuntimeException e) {
        log.error(e.getMessage(), (Throwable)e);
        return CodeResult.error(500, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public CodeResult handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return CodeResult.error(e.getLocalizedMessage());
    }
}

