/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.base.toolkit.upload;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.facecto.code.base.toolkit.oss.entity.OSSDirectParam;
import com.facecto.code.base.toolkit.upload.entity.WatermarkImage;
import com.facecto.code.base.toolkit.upload.entity.WatermarkPosition;
import com.facecto.code.base.toolkit.upload.entity.WatermarkText;
import com.facecto.code.base.toolkit.upload.entity.WatermarkType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class UploadTools {
    public String uploadFile(MultipartFile file, OSSDirectParam param) throws Exception {
        String path = System.currentTimeMillis() + this.getSuffix(file);
        return this.uploadFile(file, path, param);
    }

    public String uploadFile(MultipartFile file, String savePath, OSSDirectParam param) throws Exception {
        if (file.isEmpty()) {
            throw new Exception("Request a file.");
        }
        if (StringUtils.isEmpty((CharSequence)savePath)) {
            savePath = System.currentTimeMillis() + this.getSuffix(file);
        }
        return this.upload(file, savePath, param);
    }

    public String uploadFile(InputStream inputStream, String savePath, OSSDirectParam param) throws Exception {
        if (StringUtils.isEmpty((CharSequence)savePath)) {
            throw new Exception("Request save path.");
        }
        return this.upload(inputStream, savePath, param);
    }

    public String uploadFile(byte[] data, String savePath, OSSDirectParam param) throws Exception {
        if (StringUtils.isEmpty((CharSequence)savePath)) {
            throw new Exception("Request save path.");
        }
        return this.upload(data, savePath, param);
    }

    public String upImageBase(MultipartFile file, String savePath, WatermarkType waterType, WatermarkText waterText, WatermarkImage waterImage, OSSDirectParam param) throws Exception {
        if (file.isEmpty()) {
            throw new Exception("Request a file.");
        }
        String type = file.getContentType();
        String[] values = new String[]{".jpg", ".png"};
        if (Arrays.stream(values).anyMatch(this.getSuffix(file).toLowerCase()::equals) && type.contains("image")) {
            InputStream inputStream = file.getInputStream();
            return this.upImageBase(inputStream, savePath, waterType, waterText, waterImage, param);
        }
        return null;
    }

    public String upImageBase(InputStream inputStream, String savePath, WatermarkType waterType, WatermarkText waterText, WatermarkImage waterImage, OSSDirectParam param) throws Exception {
        if (inputStream == null) {
            throw new Exception("Request a file.");
        }
        BufferedImage image = ImageIO.read(inputStream);
        if (waterType == WatermarkType.TEXT && waterText == null) {
            waterText = new WatermarkText();
        }
        if (waterType == WatermarkType.IMAGE && waterImage == null) {
            waterImage = new WatermarkImage();
        }
        return this.upload(this.handleImage(image, waterType, waterText, waterImage), savePath, param);
    }

    public String upImageWithWatermarkImage(MultipartFile file, String savePath, WatermarkImage image, OSSDirectParam param) throws Exception {
        return this.upImageBase(file, savePath, WatermarkType.IMAGE, null, image, param);
    }

    public String upImageWithWatermarkText(MultipartFile file, String savePath, WatermarkText text, OSSDirectParam param) throws Exception {
        return this.upImageBase(file, savePath, WatermarkType.TEXT, text, null, param);
    }

    public String upImage(MultipartFile file, String savePath, OSSDirectParam param) throws Exception {
        return this.upImageBase(file, savePath, WatermarkType.NONE, null, null, param);
    }

    private InputStream handleImage(Image image, WatermarkType waterType, WatermarkText waterText, WatermarkImage waterImage) throws Exception {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 5);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, width, height, null);
        if (waterType == WatermarkType.IMAGE) {
            String waterUrl = waterImage.getWaterUrl();
            if (waterImage.getWaterUrl().startsWith("http")) {
                waterUrl = UploadTools.downloadImage(waterUrl);
            }
            ImageIcon imgIcon = new ImageIcon(waterUrl);
            Image imgWater = imgIcon.getImage();
            int iconWidth = imgWater.getWidth(null);
            int iconHeight = imgWater.getHeight(null);
            if (width - iconWidth < 0 || height - iconHeight < 0) {
                throw new Exception("The original image is smaller than the watermarked image!");
            }
            g.setComposite(AlphaComposite.getInstance(10, waterImage.getWaterAlpha()));
            Map<String, Integer> map = UploadTools.getPosition(waterImage.getPosition(), waterImage.getMarginX(), waterImage.getMarginY(), width, height, iconWidth, iconHeight);
            g.drawImage(imgWater, map.get("x"), (int)map.get("y"), null);
            g.setComposite(AlphaComposite.getInstance(3));
        }
        if (waterType == WatermarkType.TEXT) {
            Font font = new Font(waterText.getFontName(), 1, waterText.getFontSize());
            Color color = new Color(waterText.getRed(), waterText.getGreen(), waterText.getBlue(), waterText.getAlpha());
            g.setColor(color);
            g.setFont(font);
            Map<String, Integer> map = UploadTools.getPosition(waterText.getPosition(), waterText.getMarginX(), waterText.getMarginY(), width, height, 0, 0);
            g.drawString(waterText.getWaterText(), (int)map.get("x"), (int)map.get("y"));
        }
        g.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        bufferedImage.flush();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static Map<String, Integer> getPosition(WatermarkPosition position, int marginX, int marginY, int imgWidth, int imgHeight, int iconWidth, int iconHeight) {
        int x = 0;
        int y = 0;
        int xx = imgWidth - iconWidth;
        int yy = imgHeight - iconHeight;
        switch (position) {
            case TOP_CENTER: {
                x = Math.floorDiv(xx, 2);
                y = marginY;
                break;
            }
            case TOP_RIGHT: {
                x = xx - marginX;
                y = marginY;
                break;
            }
            case MIDDLE_LEFT: {
                x = marginX;
                y = Math.floorDiv(yy, 2);
                break;
            }
            case MIDDLE_CENTER: {
                x = Math.floorDiv(xx, 2);
                y = Math.floorDiv(yy, 2);
                break;
            }
            case MIDDLE_RIGHT: {
                x = xx - marginX;
                y = Math.floorDiv(yy, 2);
                break;
            }
            case UNDER_LEFT: {
                x = marginX;
                y = yy - marginY;
                break;
            }
            case UNDER_CENTER: {
                x = Math.floorDiv(xx, 2);
                y = yy - marginY;
                break;
            }
            case UNDER_RIGHT: {
                x = xx - marginX;
                y = yy - marginY;
                break;
            }
            default: {
                x = marginX;
                y = marginY;
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("x", x);
        map.put("y", y);
        return map;
    }

    private static String downloadImage(String urlString) throws IOException {
        int len;
        URL url = new URL(urlString);
        URLConnection con = url.openConnection();
        InputStream is = con.getInputStream();
        byte[] bs = new byte[1024];
        File f = new File("");
        String filename = f.getCanonicalPath() + "\\" + System.currentTimeMillis() + ".jpg";
        File file = new File(filename);
        FileOutputStream os = new FileOutputStream(file, true);
        while ((len = is.read(bs)) != -1) {
            os.write(bs, 0, len);
        }
        os.close();
        is.close();
        System.out.println(filename);
        return filename;
    }

    private String getSuffix(MultipartFile file) {
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
        return suffix;
    }

    private String upload(byte[] data, String savePath, OSSDirectParam ossParam) {
        return this.upload(new ByteArrayInputStream(data), savePath, ossParam);
    }

    private String upload(InputStream inputStream, String savePath, OSSDirectParam ossParam) {
        OSS client = new OSSClientBuilder().build(ossParam.getEndpoint(), ossParam.getAccessKeyId(), ossParam.getAccessKeySecret());
        client.putObject(ossParam.getBucketName(), savePath, inputStream);
        client.shutdown();
        return ossParam.getDomain() + "/" + savePath;
    }

    private String upload(MultipartFile file, String savePath, OSSDirectParam ossParam) throws IOException {
        InputStream stream = file.getInputStream();
        return this.upload(stream, savePath, ossParam);
    }
}

