/*
 * Decompiled with CFR 0.152.
 */
package com.facecto.code.base.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeQRUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeQRUtils.class);
    private static final int CODE_WIDTH = 400;
    private static final int CODE_HEIGHT = 400;
    private static final int COLOR_FRONT = 0;
    private static final int COLOR_BACKGROUND = 0xFFFFFF;
    private int codeWidth;
    private int codeHeight;
    private int colorFront;
    private int colorBackground;

    public CodeQRUtils(int width, int height, Integer color_front, Integer color_background) {
        this.codeWidth = width <= 0 ? 400 : width;
        this.codeHeight = height <= 0 ? 400 : height;
        this.colorFront = color_front == null || color_front <= 0 ? 0 : color_front;
        this.colorBackground = color_background == null || color_background <= 0 ? 0xFFFFFF : color_background;
    }

    public CodeQRUtils() {
        this.codeWidth = 400;
        this.codeHeight = 400;
        this.colorFront = 0;
        this.colorBackground = 0xFFFFFF;
    }

    public void create2File(String codeText, String filePath) throws WriterException, IOException {
        codeText = this.checkCodeText(codeText);
        File file = new File(filePath);
        String savePath = "";
        String saveName = "";
        if (file.isDirectory()) {
            saveName = System.currentTimeMillis() + ".png";
        } else {
            saveName = StringUtils.substringAfterLast((String)(filePath = StringUtils.substringBeforeLast((String)filePath, (String)"/")), (String)"/");
            if (!StringUtils.substringAfterLast((String)saveName, (String)".").equals("png")) {
                saveName = saveName + ".png";
            }
        }
        File codeImgFile = new File(savePath, saveName);
        ImageIO.write((RenderedImage)this.getBufferedImage(codeText), "png", codeImgFile);
        log.info("QRCode create success, the local path is " + codeImgFile.getPath());
    }

    public void create2Stream(String codeText, OutputStream outputStream) throws WriterException, IOException {
        ImageIO.write((RenderedImage)this.getBufferedImage(codeText), "png", outputStream);
        log.info("QRCode create success.");
    }

    private String checkCodeText(String codeText) {
        if (codeText == null || "".equals(codeText.trim())) {
            codeText = "Create by facecto.com QRCode utils.";
            log.info("the codeText is null.");
        }
        return codeText.trim();
    }

    private BufferedImage getBufferedImage(String codeText) throws WriterException {
        codeText = this.checkCodeText(codeText);
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.MARGIN, 1);
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(codeText, BarcodeFormat.QR_CODE, this.codeWidth, this.codeHeight, hints);
        BufferedImage bufferedImage = new BufferedImage(this.codeWidth, this.codeHeight, 4);
        for (int x = 0; x < 400; ++x) {
            for (int y = 0; y < 400; ++y) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? this.colorFront : this.colorBackground);
            }
        }
        return bufferedImage;
    }
}

