/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FieldCodec;
import com.zink.fly.FlyAccessException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CompressingFieldCodec
implements FieldCodec {
    private final int BUFFER_SIZE = 1024;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);

    @Override
    public byte[] writeField(Object object) {
        ObjectOutputStream objectOutputStream = null;
        try {
            this.bos.reset();
            objectOutputStream = new ObjectOutputStream(this.bos);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new FlyAccessException(iOException);
        }
        return this.compress(this.bos.toByteArray());
    }

    @Override
    public Object readField(byte[] byArray) {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.decompress(byArray));
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
        return object;
    }

    private byte[] compress(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Deflater deflater = new Deflater();
            deflater.setLevel(9);
            deflater.setInput(byArray);
            deflater.finish();
            byte[] byArray2 = new byte[1024];
            while (!deflater.finished()) {
                deflater.deflate(byArray2);
                byteArrayOutputStream.write(byArray2);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new FlyAccessException("Compression failed in field codec");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] decompress(byte[] byArray) {
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        try {
            byte[] byArray2 = new byte[1024];
            while (!inflater.finished()) {
                int n = inflater.inflate(byArray2);
                byteArrayOutputStream.write(byArray2, 0, n);
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException("Decompression failed in field codec");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

