/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FlyAccessException;
import com.zink.fly.Notifiable;
import com.zink.fly.NotifyHandler;
import com.zink.fly.NotifyHandlerReturningEntry;
import com.zink.fly.stub.TypeChain;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class NotifyMessageDispatcher {
    public static final long NOTIFY_SIMPLE = -1L;
    public static final long NOTIFY_WITH_OBJECT = -2L;
    private Map<Long, ClientNotifyContext> notifyContextMap = new HashMap<Long, ClientNotifyContext>();
    ExecutorService threadPool = Executors.newCachedThreadPool();
    private TypeChain typeChain;

    public NotifyMessageDispatcher(TypeChain typeChain) {
        this.typeChain = typeChain;
    }

    void registerHandler(long l, Notifiable notifiable, Class clazz) {
        ClientNotifyContext clientNotifyContext = new ClientNotifyContext(notifiable, clazz);
        this.notifyContextMap.put(l, clientNotifyContext);
    }

    void decodeAndQueue(long l, DataInputStream dataInputStream) throws IOException {
        long l2 = dataInputStream.readLong();
        ClientNotifyContext clientNotifyContext = this.notifyContextMap.get(l2);
        if (clientNotifyContext == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                throw new FlyAccessException("Notify handler thread Interrupted");
            }
            clientNotifyContext = this.notifyContextMap.get(l2);
        }
        Notifiable notifiable = clientNotifyContext.getHandler();
        PendingNotify pendingNotify = null;
        if (notifiable instanceof NotifyHandler && l == -1L) {
            pendingNotify = new PendingNotify(notifiable);
        }
        if (notifiable instanceof NotifyHandlerReturningEntry && l == -2L) {
            long l3 = dataInputStream.readLong();
            Object object = this.typeChain.readObject(dataInputStream, l3, clientNotifyContext.getClss());
            pendingNotify = new PendingNotifyWithObject(notifiable, object);
        }
        if (pendingNotify == null) {
            throw new FlyAccessException("Notify mode does not match type of notify handler");
        }
        this.threadPool.submit(pendingNotify);
    }

    class PendingNotifyWithObject
    extends PendingNotify {
        private Object entry;

        public PendingNotifyWithObject(Notifiable notifiable, Object object) {
            super(notifiable);
            this.entry = object;
        }

        @Override
        public void run() {
            ((NotifyHandlerReturningEntry)this.notifiable).templateMatched(this.entry);
        }
    }

    class PendingNotify
    implements Runnable {
        Notifiable notifiable;

        public PendingNotify(Notifiable notifiable) {
            this.notifiable = notifiable;
        }

        public void execute() {
        }

        @Override
        public void run() {
            ((NotifyHandler)this.notifiable).templateMatched();
        }
    }

    class ClientNotifyContext {
        private Notifiable handler;
        private Class clss;

        private ClientNotifyContext(Notifiable notifiable, Class clazz) {
            this.handler = notifiable;
            this.clss = clazz;
        }

        public Notifiable getHandler() {
            return this.handler;
        }

        public Class getClss() {
            return this.clss;
        }
    }
}

