/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.kit;

import com.zink.fly.stub.StringCodec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;

public class FlyPinger {
    private static final long DEFAULT_TIMEOUT = 50L;
    private static final int FLY_PORT = 4396;
    private StringCodec stringCodec = new StringCodec();
    private final long socketTimeout;

    public FlyPinger() {
        this(50L);
    }

    public FlyPinger(long l) {
        this.socketTimeout = l;
    }

    public String[] ping(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return this.ping(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] ping(InetAddress inetAddress) {
        String[] stringArray = null;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setKeepAlive(true);
            socket.bind(null);
            socket.connect(new InetSocketAddress(inetAddress, 4396), (int)this.socketTimeout);
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeInt(-88997888);
            long l = System.currentTimeMillis();
            while (dataInputStream.available() == 0 && System.currentTimeMillis() - l < this.socketTimeout) {
                Thread.sleep(1L);
            }
            if (dataInputStream.available() == 0) {
                throw new TimeoutException("No reply from fly server");
            }
            long l2 = dataInputStream.readLong();
            stringArray = new String[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                stringArray[n] = this.stringCodec.readString(dataInputStream);
                ++n;
            }
            socket.setKeepAlive(Boolean.FALSE);
            socket.shutdownInput();
            socket.shutdownOutput();
            socket.close();
        }
        catch (Exception exception) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return stringArray;
    }

    public long getTimeout() {
        return this.socketTimeout;
    }
}

