/*
 * Decompiled with CFR 0.152.
 */
package com.zink.cache;

import com.zink.cache.CacheEntry;
import com.zink.fly.Fly;
import java.io.Serializable;

public class Cache {
    private static final long DEFAULT_LEASE = 86400000L;
    private Fly fly;

    Cache(Fly fly) {
        this.fly = fly;
    }

    public final boolean set(String string, Serializable serializable) {
        this.setWithTimeout(string, serializable, 86400000L);
        return true;
    }

    public final Serializable get(String string) {
        CacheEntry cacheEntry = new CacheEntry(string);
        CacheEntry cacheEntry2 = this.fly.read(cacheEntry, 0L);
        if (cacheEntry2 != null) {
            return cacheEntry2.v;
        }
        return null;
    }

    public final boolean del(String string) {
        CacheEntry cacheEntry = new CacheEntry(string);
        return this.fly.take(cacheEntry, 0L) != null;
    }

    public boolean setnx(String string, Serializable serializable) {
        if (this.get(string) == null) {
            this.set(string, serializable);
            return true;
        }
        return false;
    }

    public boolean expire(String string, long l) {
        Serializable serializable = this.get(string);
        if (serializable != null) {
            this.setWithTimeout(string, serializable, l);
            return true;
        }
        return false;
    }

    private final void setWithTimeout(String string, Serializable serializable, long l) {
        this.del(string);
        CacheEntry cacheEntry = new CacheEntry(string, serializable);
        this.fly.write(cacheEntry, l);
    }
}

