/*
 * Decompiled with CFR 0.152.
 */
package com.zink.fly.stub;

import com.zink.fly.FlyAccessException;
import com.zink.fly.stub.FieldFilter;
import com.zink.fly.stub.FieldInfo;
import com.zink.fly.stub.StringCodec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ObjectLayout {
    private String className;
    private List<FieldInfo> infos = new ArrayList<FieldInfo>();
    private int channel;
    private StringCodec stringCodec = new StringCodec();
    private FieldFilter filter = new FieldFilter();

    public ObjectLayout(Object object) {
        this.className = object.getClass().getName();
        List<Field> list = ObjectLayout.getAllFields(object.getClass());
        for (Field field : list) {
            if (!this.filter.applyFilter(field)) continue;
            try {
                String string = field.getType().getName();
                String string2 = field.getName();
                this.infos.add(new FieldInfo(string, string2));
            }
            catch (Exception exception) {
                throw new FlyAccessException(exception);
            }
        }
    }

    public ObjectLayout(DataInputStream dataInputStream, int n) {
        try {
            this.className = this.stringCodec.readString(dataInputStream);
            this.channel = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                String string = this.stringCodec.readString(dataInputStream);
                String string2 = this.stringCodec.readString(dataInputStream);
                this.infos.add(new FieldInfo(string, string2));
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
    }

    public void write(DataOutputStream dataOutputStream) {
        try {
            this.stringCodec.writeString(dataOutputStream, this.className);
            dataOutputStream.writeInt(this.channel);
            dataOutputStream.writeInt(this.getInfos().size());
            for (FieldInfo fieldInfo : this.getInfos()) {
                this.stringCodec.writeString(dataOutputStream, fieldInfo.getType());
                this.stringCodec.writeString(dataOutputStream, fieldInfo.getName());
            }
        }
        catch (Exception exception) {
            throw new FlyAccessException(exception);
        }
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public String toString() {
        String string = new String();
        string = string + "Layout for :" + this.className + "\n";
        string = string + "Type channel :" + this.channel + "\n";
        for (FieldInfo fieldInfo : this.getInfos()) {
            string = string + "Type: " + fieldInfo.getType() + "\tName: " + fieldInfo.getName() + "\n";
        }
        return string;
    }

    public List<FieldInfo> getInfos() {
        return this.infos;
    }

    public static List<Field> getAllFields(Class clazz) {
        LinkedList<Field> linkedList = new LinkedList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            linkedList.add(field);
        }
        if (clazz.getSuperclass() != null) {
            linkedList.addAll(ObjectLayout.getAllFields(clazz.getSuperclass()));
        }
        return linkedList;
    }
}

