/*
 * Decompiled with CFR 0.152.
 */
package com.github.generatecode.template;

import com.github.generatecode.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TypeCovert {
    private static final Map<String, String> typeMapping = new HashMap<String, String>();

    private TypeCovert() {
    }

    public static Map<String, String> getInstance() {
        return typeMapping;
    }

    public static String getClassType(String type) {
        for (Map.Entry<String, String> entry : typeMapping.entrySet()) {
            String pattern = entry.getKey();
            String value = entry.getValue();
            if (!Pattern.matches(pattern, type)) continue;
            return value;
        }
        return null;
    }

    public static String getClassTypeShort(String type) {
        for (Map.Entry<String, String> entry : typeMapping.entrySet()) {
            String pattern = entry.getKey();
            String value = entry.getValue();
            if (!Pattern.matches(pattern, type)) continue;
            return StringUtils.getLastVal(value);
        }
        return null;
    }

    static {
        typeMapping.put("varchar(\\(\\d+\\))?", "java.lang.String");
        typeMapping.put("char(\\(\\d+\\))?", "java.lang.String");
        typeMapping.put("text", "java.lang.String");
        typeMapping.put("decimal(\\(\\d+\\))?", "java.math.BigDecimal");
        typeMapping.put("decimal(\\(\\d+,\\d+\\))?", "java.math.BigDecimal");
        typeMapping.put("integer", "java.lang.Integer");
        typeMapping.put("int(\\(\\d+\\))?", "java.lang.Integer");
        typeMapping.put("float(\\(\\d+\\))?", "java.math.BigDecimal");
        typeMapping.put("double(\\(\\d+\\))?", "java.math.BigDecimal");
        typeMapping.put("int4", "java.lang.Integer");
        typeMapping.put("int8", "java.lang.Long");
        typeMapping.put("bigint(\\(\\d+\\))?", "java.lang.Long");
        typeMapping.put("tinyint(\\(\\d+\\))?", "java.lang.Integer");
        typeMapping.put("datetime", "java.util.Date");
        typeMapping.put("timestamp", "java.util.Date");
        typeMapping.put("boolean", "java.lang.Boolean");
    }
}

