/*
 * Decompiled with CFR 0.152.
 */
package com.github.generatecode.util;

import com.github.generatecode.model.MatchKeywordStartToEnd;
import com.github.generatecode.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatches {
    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isEmpty(keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static String escapeExprSpecialWordSpecial(String keyword) {
        if (!StringUtils.isEmpty(keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "#", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public static List<MatchKeywordStartToEnd> matchKeywordStartToEnd(String start, String end, String text) {
        ArrayList<MatchKeywordStartToEnd> list = new ArrayList<MatchKeywordStartToEnd>();
        String regex = RegexMatches.getRegex(start, end);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        while (m.find()) {
            String str = text.substring(m.start(), m.end());
            list.add(new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str));
        }
        return list;
    }

    public static List<MatchKeywordStartToEnd> matchKeywordStartToEndFindone(String start, String end, String text) {
        ArrayList<MatchKeywordStartToEnd> list = new ArrayList<MatchKeywordStartToEnd>();
        String regex = RegexMatches.getRegex(start, end);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String str = text.substring(m.start(), m.end());
            list.add(new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str));
            return list;
        }
        return list;
    }

    public static List<MatchKeywordStartToEnd> matchKeywordStartToEndFindoneRegex(String start, String end, String text) {
        start = RegexMatches.escapeExprSpecialWord(start);
        end = RegexMatches.escapeExprSpecialWord(end);
        ArrayList<MatchKeywordStartToEnd> list = new ArrayList<MatchKeywordStartToEnd>();
        String regex = RegexMatches.getRegex(start, end);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String str = text.substring(m.start(), m.end());
            list.add(new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str));
            return list;
        }
        return list;
    }

    public static MatchKeywordStartToEnd matchKeywordStartToEndFindoneRegexLimit1(String start, String end, String text) {
        System.err.println(start + "]]]]" + end + "]]]]" + text);
        start = RegexMatches.escapeExprSpecialWord(start);
        end = RegexMatches.escapeExprSpecialWord(end);
        String regex = RegexMatches.getRegex(start, end);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String str = text.substring(m.start(), m.end());
            return new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str);
        }
        return null;
    }

    public static MatchKeywordStartToEnd matchKeywordStartToEndFindoneRegexLimit1FromLetter(String start, String end, String text) {
        String regex = RegexMatches.getRegexFromLetter(start = RegexMatches.escapeExprSpecialWord(start), end = RegexMatches.escapeExprSpecialWord(end));
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String str = text.substring(m.start(), m.end());
            return new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str);
        }
        return null;
    }

    public static String getRegex(String start, String end) {
        return StringUtils.concat("\\", start, "(?<scope>[\\s\\S]*?)", end);
    }

    public static String getRegexFromLetter(String start, String end) {
        return StringUtils.concat(start, "(?<scope>[\\s\\S]*?)", end);
    }

    public static MatchKeywordStartToEnd matchKeywordStartToEndFindoneRegexLimit1Specal(String start, String end, String text) {
        start = RegexMatches.escapeExprSpecialWordSpecial(start);
        end = RegexMatches.escapeExprSpecialWordSpecial(end);
        String regex = RegexMatches.getRegexFromLetter(start, end);
        System.err.println(regex);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String str = text.substring(m.start(), m.end());
            return new MatchKeywordStartToEnd(m.start(), m.end(), m.group("scope"), str);
        }
        return null;
    }
}

