/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.FSSupplier;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.java2d.Java2DFontContext;
import com.openhtmltopdf.java2d.Java2DFontResolver;
import com.openhtmltopdf.java2d.Java2DOutputDevice;
import com.openhtmltopdf.java2d.Java2DReplacedElementFactory;
import com.openhtmltopdf.java2d.Java2DTextRenderer;
import com.openhtmltopdf.java2d.Java2DUserAgent;
import com.openhtmltopdf.java2d.api.FSPage;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import com.openhtmltopdf.java2d.api.Java2DRendererBuilderState;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.AddedFont;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceControlPriority;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.outputdevice.helper.NullUserInterface;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.render.displaylist.DisplayListCollector;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListPainter;
import com.openhtmltopdf.render.simplepainter.SimplePainter;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class Java2DRenderer
implements Closeable {
    private final List<FSDOMMutator> _domMutators;
    private final SVGDrawer _mathMLImpl;
    private BlockBox _root;
    private final SharedContext _sharedContext;
    private final Java2DOutputDevice _outputDevice;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;
    private final SVGDrawer _svgImpl;
    private Document _doc;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final FSPageProcessor _pageProcessor;
    private static final int DEFAULT_DOTS_PER_PIXEL = 1;
    private static final int DEFAULT_DPI = 72;
    private final int _initialPageNo;
    private final short _pagingMode;
    private final Closeable diagnosticConsumer;

    public Java2DRenderer(BaseDocument doc, UnicodeImplementation unicode, PageDimensions pageSize, Java2DRendererBuilderState state, Closeable diagnosticConsumer) {
        this.diagnosticConsumer = diagnosticConsumer;
        this._pagingMode = state._pagingMode;
        this._pageProcessor = state._pageProcessor;
        this._initialPageNo = state._initialPageNumber;
        this._svgImpl = state._svgImpl;
        this._mathMLImpl = state._mathmlImpl;
        this._domMutators = state._domMutators;
        this._objectDrawerFactory = state._objectDrawerFactory;
        this._outputDevice = new Java2DOutputDevice(state._layoutGraphics);
        Java2DUserAgent uac = new Java2DUserAgent();
        uac.setProtocolsStreamFactory(state._streamFactoryMap);
        if (state._resolver != null) {
            uac.setUriResolver(state._resolver);
        }
        uac.setAccessController(ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI, state._beforeAccessController);
        uac.setAccessController(ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI, state._afterAccessController);
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext._preferredTransformerFactoryImplementationClass = state._preferredTransformerFactoryImplementationClass;
        this._sharedContext._preferredDocumentBuilderFactoryImplementationClass = state._preferredDocumentBuilderFactoryImplementationClass;
        this._sharedContext.setUserAgentCallback((UserAgentCallback)uac);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)uac));
        Java2DFontResolver fontResolver = new Java2DFontResolver(this._sharedContext, state._useEnvironmentFonts);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        for (AddedFont font : state._fonts) {
            IdentValue fontStyle = null;
            if (font.style == BaseRendererBuilder.FontStyle.NORMAL) {
                fontStyle = IdentValue.NORMAL;
            } else if (font.style == BaseRendererBuilder.FontStyle.ITALIC) {
                fontStyle = IdentValue.ITALIC;
            } else if (font.style == BaseRendererBuilder.FontStyle.OBLIQUE) {
                fontStyle = IdentValue.OBLIQUE;
            }
            if (font.supplier != null) {
                fontResolver.addInputStreamFont((FSSupplier<InputStream>)font.supplier, font.family, font.weight, fontStyle);
                continue;
            }
            fontResolver.addFontFile(font.fontFile, font.family, font.weight, fontStyle);
        }
        Java2DReplacedElementFactory replacedFactory = new Java2DReplacedElementFactory(this._svgImpl, this._objectDrawerFactory, this._mathMLImpl);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new Java2DTextRenderer());
        this._sharedContext.setDPI(72.0f);
        this._sharedContext.setDotsPerPixel(1);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
        this._sharedContext.setDefaultPageSize(pageSize.w, pageSize.h, pageSize.isSizeInches);
        if (state._replacementText != null) {
            this._sharedContext.setReplacementText(state._replacementText);
        }
        if (unicode.splitterFactory != null) {
            this._splitterFactory = unicode.splitterFactory;
        }
        if (unicode.reorderer != null) {
            this._reorderer = unicode.reorderer;
            this._outputDevice.setBidiReorderer(this._reorderer);
        }
        if (unicode.lineBreaker != null) {
            this._sharedContext.setLineBreaker(unicode.lineBreaker);
        }
        if (unicode.charBreaker != null) {
            this._sharedContext.setCharacterBreaker(unicode.charBreaker);
        }
        if (unicode.toLowerTransformer != null) {
            this._sharedContext.setUnicodeToLowerTransformer(unicode.toLowerTransformer);
        }
        if (unicode.toUpperTransformer != null) {
            this._sharedContext.setUnicodeToUpperTransformer(unicode.toUpperTransformer);
        }
        if (unicode.toTitleTransformer != null) {
            this._sharedContext.setUnicodeToTitleTransformer(unicode.toTitleTransformer);
        }
        byte by = this._defaultTextDirection = unicode.textDirection ? (byte)1 : 0;
        if (doc.html != null) {
            this.setDocumentFromString(doc.html, doc.baseUri);
        } else if (doc.document != null) {
            this.setDocument(doc.document, doc.baseUri);
        } else if (doc.uri != null) {
            this.setDocument(doc.uri);
        } else if (doc.file != null) {
            try {
                this.setDocument(doc.file);
            }
            catch (IOException e) {
                XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId0Param)LogMessageId.LogMessageId0Param.EXCEPTION_PROBLEM_TRYING_TO_READ_INPUT_XHTML_FILE, (Throwable)e);
                throw new RuntimeException("File IO problem", e);
            }
        }
    }

    private void setDocumentFromString(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocument(dom, baseUrl);
    }

    private void setDocument(Document doc, String url) {
        this.setDocument(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    private void setDocument(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    private void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUserAgentCallback().getXMLResource(uri, ExternalResourceType.XML_XHTML).getDocument();
    }

    private void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        for (FSDOMMutator domMutator : this._domMutators) {
            domMutator.mutateDocument(doc);
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
        if (this._svgImpl != null) {
            this._svgImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
        if (this._mathMLImpl != null) {
            this._mathMLImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
    }

    public Java2DFontResolver getFontResolver() {
        return (Java2DFontResolver)this._sharedContext.getFontResolver();
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages((CssContext)c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new Java2DFontContext(this._outputDevice.getGraphics()));
        result.setOutputDevice((OutputDevice)this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new Java2DFontContext(this._outputDevice.getGraphics()));
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((Java2DTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)(this._reorderer != null ? this._reorderer : new SimpleBidiReorderer()));
        return result;
    }

    public void writePages() throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        c.setFastRenderer(true);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, firstPage.getWidth((CssContext)c) / 1, firstPage.getHeight((CssContext)c) / 1);
        this.writePageImages(pages, c, firstPageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(int zeroBasedPageNumber) throws IOException {
        List pages = this._root.getLayer().getPages();
        if (zeroBasedPageNumber >= pages.size()) {
            throw new IndexOutOfBoundsException();
        }
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        c.setFastRenderer(true);
        PageBox page = (PageBox)pages.get(zeroBasedPageNumber);
        Rectangle2D.Float pageSize = new Rectangle2D.Float(0.0f, 0.0f, page.getWidth((CssContext)c) / 1, page.getHeight((CssContext)c) / 1);
        this._outputDevice.setRoot(this._root);
        FSPage pg = this._pageProcessor.createPage(zeroBasedPageNumber, (int)((RectangularShape)pageSize).getWidth(), (int)((RectangularShape)pageSize).getHeight());
        try {
            this._outputDevice.initializePage(pg.getGraphics());
            this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
            c.setPageCount(pages.size());
            c.setPage(zeroBasedPageNumber, page);
            DisplayListCollector boxCollector = new DisplayListCollector(pages);
            DisplayListContainer displayList = boxCollector.collectRoot(c, this._root.getLayer());
            this.paintPage(c, page, displayList.getPageInstructions(zeroBasedPageNumber));
        }
        finally {
            this._pageProcessor.finishPage(pg);
            this._outputDevice.finish(c, this._root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSinglePage() {
        List pages = this._root.getLayer().getPages();
        int rootHeight = this._root.getHeight();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(this._initialPageNo);
        c.setFastRenderer(true);
        PageBox page = (PageBox)pages.get(0);
        Rectangle2D.Float pageSize = new Rectangle2D.Float(0.0f, 0.0f, page.getWidth((CssContext)c) / 1, rootHeight / 1);
        this._outputDevice.setRoot(this._root);
        int top = page.getMarginBorderPadding((CssContext)c, 3);
        int bottom = page.getMarginBorderPadding((CssContext)c, 4);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        FSPage pg = this._pageProcessor.createPage(0, (int)((RectangularShape)pageSize).getWidth(), rootHeight + top + bottom);
        try {
            this._outputDevice.initializePage(pg.getGraphics());
            this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
            page.setPaintingBottom(rootHeight + top + bottom);
            c.setPageCount(pages.size());
            c.setPage(0, page);
            page.paintBackground(c, 0, this._pagingMode);
            page.paintMarginAreas(c, 0, this._pagingMode);
            page.paintBorder(c, 0, this._pagingMode);
            Rectangle printClip = page.getPrintClippingBounds((CssContext)c);
            Rectangle pageClip = new Rectangle(0, 0, printClip.width, rootHeight);
            this._outputDevice.pushTransformLayer(AffineTransform.getTranslateInstance(left, top));
            this._outputDevice.pushClip(pageClip);
            SimplePainter painter = new SimplePainter(0, 0);
            painter.paintLayer(c, this._root.getLayer());
            this._outputDevice.popClip();
            this._outputDevice.popTransformLayer();
        }
        finally {
            this._pageProcessor.finishPage(pg);
            this._outputDevice.finish(c, this._root);
        }
    }

    public int getPageCount() {
        return this._root.getLayer().getPages().size();
    }

    private void writePageImages(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize) throws IOException {
        this._outputDevice.setRoot(this._root);
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, this._pagingMode);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        DisplayListCollector boxCollector = new DisplayListCollector(pages);
        DisplayListContainer displayList = boxCollector.collectRoot(c, this._root.getLayer());
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            c.setPage(i, currentPage);
            Rectangle2D pageSize = i == 0 ? firstPageSize : new Rectangle2D.Float(0.0f, 0.0f, currentPage.getWidth((CssContext)c) / 1, currentPage.getHeight((CssContext)c) / 1);
            FSPage pg = this.initPage(pageSize, i);
            try {
                this.paintPage(c, currentPage, displayList.getPageInstructions(i));
                continue;
            }
            finally {
                this._pageProcessor.finishPage(pg);
            }
        }
        this._outputDevice.finish(c, this._root);
    }

    private FSPage initPage(Rectangle2D pageSize, int idx) {
        FSPage pg = this._pageProcessor.createPage(idx, (int)pageSize.getWidth(), (int)pageSize.getHeight());
        try {
            this._outputDevice.initializePage(pg.getGraphics());
        }
        catch (Throwable e) {
            this._pageProcessor.finishPage(pg);
            throw e;
        }
        return pg;
    }

    private void paintPage(RenderingContext c, PageBox page, DisplayListContainer.DisplayListPageContainer pageOperations) {
        page.paintBackground(c, 0, this._pagingMode);
        page.paintMarginAreas(c, 0, this._pagingMode);
        page.paintBorder(c, 0, this._pagingMode);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        Rectangle content = new Rectangle(0, page.getPaintingTop(), page.getContentWidth((CssContext)c), page.getContentHeight((CssContext)c));
        this._outputDevice.pushTransformLayer(AffineTransform.getTranslateInstance(left, top));
        this._outputDevice.pushClip(content);
        DisplayListPainter painter = new DisplayListPainter();
        painter.paint(c, pageOperations);
        this._outputDevice.popClip();
        this._outputDevice.popTransformLayer();
    }

    @Override
    public void close() {
        OpenUtil.tryQuietly(() -> ((SharedContext)this._sharedContext).removeFromThread());
        OpenUtil.tryQuietly(ThreadCtx::cleanup);
        OpenUtil.closeQuietly((Closeable)this.diagnosticConsumer);
        OpenUtil.closeQuietly((Closeable)this._svgImpl);
        OpenUtil.closeQuietly((Closeable)this._mathMLImpl);
    }
}

