/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.java2d.image.AWTFSImage;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceControlPriority;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.swing.NaiveUserAgent;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class Java2DUserAgent
extends NaiveUserAgent {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageResource getImageResource(String uri, ExternalResourceType type) {
        if (!this.checkAccessAllowed(uri, type, ExternalResourceControlPriority.RUN_BEFORE_RESOLVING_URI)) {
            return null;
        }
        String resolved = this._resolver.resolveURI(this._baseUri, uri);
        if (!this.checkAccessAllowed(resolved, type, ExternalResourceControlPriority.RUN_AFTER_RESOLVING_URI)) {
            return null;
        }
        if (resolved == null) {
            XRLog.log((Level)Level.INFO, (LogMessageId.LogMessageId2Param)LogMessageId.LogMessageId2Param.LOAD_URI_RESOLVER_REJECTED_LOADING_AT_URI, (Object)"image resource", (Object)uri);
            return null;
        }
        ImageResource ir = (ImageResource)this._imageCache.get(resolved);
        if (ir != null) {
            return ir;
        }
        try (InputStream is = this.openStream(resolved);){
            if (is == null) return new ImageResource(resolved, null);
            BufferedImage img = ImageIO.read(is);
            if (img == null) {
                throw new IOException("ImageIO.read() returned null");
            }
            AWTFSImage fsImage2 = (AWTFSImage)AWTFSImage.createImage(img);
            ir = new ImageResource(resolved, (FSImage)fsImage2);
            this._imageCache.put(resolved, ir);
            ImageResource imageResource = ir;
            return imageResource;
        }
        catch (FileNotFoundException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_CANT_READ_IMAGE_FILE_FOR_URI_NOT_FOUND, (Object)resolved);
            return new ImageResource(resolved, null);
        }
        catch (IOException e) {
            XRLog.log((Level)Level.WARNING, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.EXCEPTION_CANT_READ_IMAGE_FILE_FOR_URI, (Object)uri, (Throwable)e);
        }
        return new ImageResource(resolved, null);
    }
}

