/*
 * Decompiled with CFR 0.152.
 */
package com.github.antlrjavaparser.adapter;

import com.github.antlrjavaparser.Java7Parser;
import com.github.antlrjavaparser.adapter.Adapter;
import com.github.antlrjavaparser.adapter.AdapterParameters;
import com.github.antlrjavaparser.adapter.AdapterUtil;
import com.github.antlrjavaparser.adapter.Adapters;
import com.github.antlrjavaparser.api.expr.ArrayAccessExpr;
import com.github.antlrjavaparser.api.expr.ClassExpr;
import com.github.antlrjavaparser.api.expr.Expression;
import com.github.antlrjavaparser.api.expr.FieldAccessExpr;
import com.github.antlrjavaparser.api.expr.MethodCallExpr;
import com.github.antlrjavaparser.api.expr.NameExpr;
import com.github.antlrjavaparser.api.expr.ObjectCreationExpr;
import com.github.antlrjavaparser.api.expr.ThisExpr;
import com.github.antlrjavaparser.api.type.ClassOrInterfaceType;
import com.github.antlrjavaparser.api.type.ReferenceType;
import com.github.antlrjavaparser.api.type.Type;
import com.github.antlrjavaparser.api.type.VoidType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryContextAdapter
implements Adapter<Expression, Java7Parser.PrimaryContext> {
    @Override
    public Expression adapt(Java7Parser.PrimaryContext context, AdapterParameters adapterParameters) {
        if (context.parExpression() != null) {
            return Adapters.getParExpressionContextAdapter().adapt(context.parExpression(), adapterParameters);
        }
        if (context.operationType == 2) {
            return this.handleThisSuffix(context, adapterParameters);
        }
        if (context.operationType == 3) {
            return this.handleIdentifierSuffix(context, adapterParameters);
        }
        if (context.SUPER() != null) {
            return Adapters.getSuperSuffixContextAdapter().adapt(context.superSuffix(), adapterParameters);
        }
        if (context.literal() != null) {
            return Adapters.getLiteralContextAdapter().adapt(context.literal(), adapterParameters);
        }
        if (context.creator() != null) {
            return Adapters.getCreatorContextAdapter().adapt(context.creator(), adapterParameters);
        }
        if (context.primitiveType() != null) {
            ClassExpr classExpr = new ClassExpr();
            AdapterUtil.setComments(classExpr, context, adapterParameters);
            Type type = Adapters.getPrimitiveTypeContextAdapter().adapt(context.primitiveType(), adapterParameters);
            if (context.LBRACKET() != null && context.LBRACKET().size() > 0) {
                ReferenceType referenceType = new ReferenceType();
                referenceType.setType(type);
                referenceType.setArrayCount(context.LBRACKET().size());
                type = referenceType;
            }
            classExpr.setType(type);
            return classExpr;
        }
        if (context.VOID() != null) {
            ClassExpr classExpr = new ClassExpr();
            AdapterUtil.setComments(classExpr, context, adapterParameters);
            classExpr.setType(new VoidType());
            return classExpr;
        }
        throw new RuntimeException("Unknown or unhandled primary context");
    }

    private Expression handleIdentifierSuffix(Java7Parser.PrimaryContext primaryContext, AdapterParameters adapterParameters) {
        NameExpr nameExpr = new NameExpr();
        nameExpr.setName(primaryContext.Identifier(0).getText());
        Expression leftExpression = nameExpr;
        for (int i = 1; i < primaryContext.Identifier().size(); ++i) {
            FieldAccessExpr fieldAccessExpr = new FieldAccessExpr();
            fieldAccessExpr.setField(primaryContext.Identifier(i).getText());
            fieldAccessExpr.setScope(leftExpression);
            leftExpression = fieldAccessExpr;
        }
        if (primaryContext.identifierSuffix() == null) {
            return leftExpression;
        }
        ClassOrInterfaceType rootType = new ClassOrInterfaceType();
        if (primaryContext.Identifier() != null && primaryContext.Identifier().size() > 0) {
            rootType.setName(primaryContext.Identifier(0).getText());
        }
        switch (primaryContext.identifierSuffix().operationType) {
            case 1: 
            case 4: {
                ClassOrInterfaceType leftType = rootType;
                for (int i = 0; i < primaryContext.Identifier().size(); ++i) {
                    ClassOrInterfaceType classOrInterfaceType = new ClassOrInterfaceType();
                    classOrInterfaceType.setName(primaryContext.Identifier(i).getText());
                    if (i > 0) {
                        classOrInterfaceType.setScope(leftType);
                    }
                    leftType = classOrInterfaceType;
                }
                ReferenceType referenceType = new ReferenceType();
                referenceType.setType(leftType);
                if (primaryContext.identifierSuffix().LBRACKET() != null) {
                    referenceType.setArrayCount(primaryContext.identifierSuffix().LBRACKET().size());
                }
                ClassExpr classExpr = new ClassExpr();
                classExpr.setType(referenceType);
                return classExpr;
            }
            case 2: {
                for (int i = 0; i < primaryContext.identifierSuffix().LBRACKET().size(); ++i) {
                    ArrayAccessExpr arrayAccessExpr = new ArrayAccessExpr();
                    arrayAccessExpr.setName(leftExpression);
                    arrayAccessExpr.setIndex(Adapters.getExpressionContextAdapter().adapt(primaryContext.identifierSuffix().expression(i), adapterParameters));
                    leftExpression = arrayAccessExpr;
                }
                return leftExpression;
            }
            case 3: {
                MethodCallExpr methodCallExpr = new MethodCallExpr();
                if (leftExpression instanceof NameExpr) {
                    methodCallExpr.setName(((NameExpr)leftExpression).getName());
                } else if (leftExpression instanceof FieldAccessExpr) {
                    methodCallExpr.setName(((FieldAccessExpr)leftExpression).getField());
                    leftExpression = ((FieldAccessExpr)leftExpression).getScope();
                    methodCallExpr.setScope(leftExpression);
                }
                methodCallExpr.setArgs(Adapters.getArgumentsContextAdapter().adapt(primaryContext.identifierSuffix().arguments(), adapterParameters));
                leftExpression = methodCallExpr;
                return leftExpression;
            }
            case 5: {
                List<Type> typeList = Adapters.getTypeListContextAdapter().adapt(primaryContext.identifierSuffix().nonWildcardTypeArguments().typeList(), adapterParameters);
                MethodCallExpr typeArgMethodCallExpr = new MethodCallExpr();
                typeArgMethodCallExpr.setName(primaryContext.identifierSuffix().Identifier().getText());
                typeArgMethodCallExpr.setTypeArgs(typeList);
                typeArgMethodCallExpr.setScope(leftExpression);
                typeArgMethodCallExpr.setArgs(Adapters.getArgumentsContextAdapter().adapt(primaryContext.identifierSuffix().arguments(), adapterParameters));
                leftExpression = typeArgMethodCallExpr;
                return leftExpression;
            }
            case 6: {
                ThisExpr thisExpr = new ThisExpr();
                thisExpr.setClassExpr(leftExpression);
                return thisExpr;
            }
            case 7: {
                ObjectCreationExpr objectCreationExpr = Adapters.getInnerCreatorContextAdapter().adapt(primaryContext.identifierSuffix().innerCreator(), adapterParameters);
                objectCreationExpr.setScope(leftExpression);
                return objectCreationExpr;
            }
        }
        return null;
    }

    private Expression handleThisSuffix(Java7Parser.PrimaryContext primaryContext, AdapterParameters adapterParameters) {
        ThisExpr thisExpr;
        Expression leftExpression = thisExpr = new ThisExpr();
        for (int i = 0; i < primaryContext.Identifier().size(); ++i) {
            FieldAccessExpr fieldAccessExpr = new FieldAccessExpr();
            fieldAccessExpr.setField(primaryContext.Identifier(i).getText());
            fieldAccessExpr.setScope(leftExpression);
            leftExpression = fieldAccessExpr;
        }
        if (primaryContext.thisSuffix() == null) {
            return leftExpression;
        }
        ClassOrInterfaceType rootType = new ClassOrInterfaceType();
        if (primaryContext.Identifier() != null && primaryContext.Identifier().size() > 0) {
            rootType.setName(primaryContext.Identifier(0).getText());
        }
        switch (primaryContext.thisSuffix().operationType) {
            case 1: {
                for (int i = 0; i < primaryContext.thisSuffix().LBRACKET().size(); ++i) {
                    ArrayAccessExpr arrayAccessExpr = new ArrayAccessExpr();
                    arrayAccessExpr.setName(leftExpression);
                    arrayAccessExpr.setIndex(Adapters.getExpressionContextAdapter().adapt(primaryContext.thisSuffix().expression(i), adapterParameters));
                    leftExpression = arrayAccessExpr;
                }
                return leftExpression;
            }
            case 2: {
                MethodCallExpr methodCallExpr = new MethodCallExpr();
                if (leftExpression instanceof FieldAccessExpr) {
                    methodCallExpr.setName(((FieldAccessExpr)leftExpression).getField());
                    leftExpression = ((FieldAccessExpr)leftExpression).getScope();
                    methodCallExpr.setScope(leftExpression);
                }
                if (methodCallExpr.getName() == null) {
                    throw new RuntimeException("Syntax Error: possibly calling 'this' as a method with arguments.  Something like 'this(\"\")'");
                }
                methodCallExpr.setArgs(Adapters.getArgumentsContextAdapter().adapt(primaryContext.thisSuffix().arguments(), adapterParameters));
                leftExpression = methodCallExpr;
                return leftExpression;
            }
            case 3: {
                List<Type> typeList = Adapters.getTypeListContextAdapter().adapt(primaryContext.thisSuffix().nonWildcardTypeArguments().typeList(), adapterParameters);
                MethodCallExpr typeArgMethodCallExpr = new MethodCallExpr();
                typeArgMethodCallExpr.setName(primaryContext.thisSuffix().Identifier().getText());
                typeArgMethodCallExpr.setTypeArgs(typeList);
                typeArgMethodCallExpr.setScope(leftExpression);
                typeArgMethodCallExpr.setArgs(Adapters.getArgumentsContextAdapter().adapt(primaryContext.thisSuffix().arguments(), adapterParameters));
                leftExpression = typeArgMethodCallExpr;
                return leftExpression;
            }
            case 4: {
                ObjectCreationExpr objectCreationExpr = Adapters.getInnerCreatorContextAdapter().adapt(primaryContext.thisSuffix().innerCreator(), adapterParameters);
                objectCreationExpr.setScope(leftExpression);
                return objectCreationExpr;
            }
        }
        return null;
    }
}

