/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.bbottema.javasocksproxyserver.Socks4Impl;
import org.bbottema.javasocksproxyserver.Socks5Impl;
import org.bbottema.javasocksproxyserver.Utils;
import org.jacoco.agent.rt.internal_c13123e.Offline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHandler
implements Runnable {
    private static final Logger LOGGER;
    private InputStream m_ClientInput;
    private OutputStream m_ClientOutput;
    private InputStream m_ServerInput;
    private OutputStream m_ServerOutput;
    private Object m_lock;
    private Socks4Impl comm;
    Socket m_ClientSocket;
    Socket m_ServerSocket;
    byte[] m_Buffer;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public ProxyHandler(Socket clientSocket) {
        if (clientSocket == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.<init> must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        this.m_ClientInput = null;
        this.m_ClientOutput = null;
        this.m_ServerInput = null;
        this.m_ServerOutput = null;
        this.comm = null;
        this.m_ServerSocket = null;
        this.m_Buffer = new byte[4096];
        this.m_lock = this;
        this.m_ClientSocket = clientSocket;
        try {
            blArray[0] = true;
            this.m_ClientSocket.setSoTimeout(10);
            blArray[1] = true;
        }
        catch (SocketException socketException) {
            blArray[2] = true;
            LOGGER.error("Socket Exception during seting Timeout.");
            blArray[3] = true;
        }
        LOGGER.debug("Proxy Created.");
        blArray[4] = true;
    }

    public void setLock(Object lock) {
        if (lock == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.setLock must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        this.m_lock = lock;
        blArray[5] = true;
    }

    @Override
    public void run() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        LOGGER.debug("Proxy Started.");
        blArray[6] = true;
        this.setLock(this);
        blArray[7] = true;
        if (this.prepareClient()) {
            blArray[8] = true;
            this.processRelay();
            blArray[9] = true;
            this.close();
            blArray[10] = true;
        } else {
            LOGGER.error("Proxy - client socket is null !");
            blArray[11] = true;
        }
        blArray[12] = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        block20: {
            block18: {
                block19: {
                    block16: {
                        block17: {
                            block15: {
                                var1_1 = ProxyHandler.$jacocoInit();
                                try {
                                    if (this.m_ClientOutput == null) {
                                        var1_1[13] = true;
                                    } else {
                                        var1_1[14] = true;
                                        this.m_ClientOutput.flush();
                                        var1_1[15] = true;
                                        this.m_ClientOutput.close();
                                        var1_1[16] = true;
                                    }
                                    var1_1[17] = true;
                                    ** GOTO lbl16
                                }
                                catch (IOException var2_2) {
                                    try {
                                        var1_1[18] = true;
lbl16:
                                        // 2 sources

                                        if (this.m_ServerOutput == null) {
                                            var1_1[19] = true;
                                            break block15;
                                        }
                                        var1_1[20] = true;
                                        this.m_ServerOutput.flush();
                                        var1_1[21] = true;
                                        this.m_ServerOutput.close();
                                    }
                                    catch (IOException var2_3) {
                                        try {
                                            var1_1[24] = true;
lbl27:
                                            // 2 sources

                                            while (true) {
                                                if (this.m_ClientSocket == null) {
                                                    var1_1[25] = true;
                                                    break block16;
                                                }
                                                var1_1[26] = true;
                                                this.m_ClientSocket.close();
                                                break block17;
                                                break;
                                            }
                                        }
                                        catch (IOException var2_4) {
                                            try {
                                                var1_1[29] = true;
lbl37:
                                                // 2 sources

                                                while (true) {
                                                    if (this.m_ServerSocket == null) {
                                                        var1_1[30] = true;
                                                        break block18;
                                                    }
                                                    var1_1[31] = true;
                                                    this.m_ServerSocket.close();
                                                    break block19;
                                                    break;
                                                }
                                            }
                                            catch (IOException var2_5) {
                                                var1_1[34] = true;
                                                break block20;
                                            }
                                        }
                                    }
                                }
                                var1_1[22] = true;
                            }
                            var1_1[23] = true;
                            ** while (true)
                        }
                        var1_1[27] = true;
                    }
                    var1_1[28] = true;
                    ** while (true)
                }
                var1_1[32] = true;
            }
            var1_1[33] = true;
        }
        this.m_ServerSocket = null;
        this.m_ClientSocket = null;
        var1_1[35] = true;
        ProxyHandler.LOGGER.debug("Proxy Closed.");
        var1_1[36] = true;
    }

    public void sendToClient(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.sendToClient must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        this.sendToClient(buffer, buffer.length);
        blArray[37] = true;
    }

    public void sendToClient(byte[] buffer, int len) {
        if (buffer == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.sendToClient must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        if (this.m_ClientOutput == null) {
            blArray[38] = true;
        } else if (len <= 0) {
            blArray[39] = true;
        } else if (len > buffer.length) {
            blArray[40] = true;
        } else {
            try {
                blArray[41] = true;
                this.m_ClientOutput.write(buffer, 0, len);
                blArray[42] = true;
                this.m_ClientOutput.flush();
                blArray[43] = true;
            }
            catch (IOException iOException) {
                blArray[44] = true;
                LOGGER.error("Sending data to client");
                blArray[45] = true;
            }
        }
        blArray[46] = true;
    }

    public void sendToServer(byte[] buffer, int len) {
        if (buffer == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.sendToServer must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        if (this.m_ServerOutput == null) {
            blArray[47] = true;
        } else if (len <= 0) {
            blArray[48] = true;
        } else if (len > buffer.length) {
            blArray[49] = true;
        } else {
            try {
                blArray[50] = true;
                this.m_ServerOutput.write(buffer, 0, len);
                blArray[51] = true;
                this.m_ServerOutput.flush();
                blArray[52] = true;
            }
            catch (IOException iOException) {
                blArray[53] = true;
                LOGGER.error("Sending data to server");
                blArray[54] = true;
            }
        }
        blArray[55] = true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isActive() {
        block2: {
            var1_1 = ProxyHandler.$jacocoInit();
            if (this.m_ClientSocket != null) break block2;
            var1_1[56] = true;
            ** GOTO lbl10
        }
        if (this.m_ServerSocket != null) {
            v0 = var1_1[58] = true;
        } else {
            var1_1[57] = true;
lbl10:
            // 2 sources

            v0 = false;
            var1_1[59] = true;
        }
        var1_1[60] = true;
        return v0;
    }

    public void connectToServer(String server, int port) throws IOException {
        if (server == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/ProxyHandler.connectToServer must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        if (server.equals("")) {
            blArray[61] = true;
            this.close();
            blArray[62] = true;
            LOGGER.error("Invalid Remote Host Name - Empty String !!!");
            blArray[63] = true;
            return;
        }
        this.m_ServerSocket = new Socket(server, port);
        blArray[64] = true;
        this.m_ServerSocket.setSoTimeout(10);
        blArray[65] = true;
        LOGGER.debug("Connected to " + Utils.getSocketInfo(this.m_ServerSocket));
        blArray[66] = true;
        this.prepareServer();
        blArray[67] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareServer() throws IOException {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        Object object = this.m_lock;
        synchronized (object) {
            try {
                blArray[68] = true;
                this.m_ServerInput = this.m_ServerSocket.getInputStream();
                blArray[69] = true;
                this.m_ServerOutput = this.m_ServerSocket.getOutputStream();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[70] = true;
                throw throwable;
            }
        }
        blArray[71] = true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean prepareClient() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        if (this.m_ClientSocket == null) {
            blArray[73] = true;
            return false;
        }
        blArray[72] = true;
        try {
            this.m_ClientInput = this.m_ClientSocket.getInputStream();
            blArray[74] = true;
            this.m_ClientOutput = this.m_ClientSocket.getOutputStream();
            blArray[75] = true;
            return blArray[75];
        }
        catch (IOException iOException) {
            void e;
            blArray[76] = true;
            LOGGER.error("Proxy - can't get I/O streams!");
            blArray[77] = true;
            LOGGER.error(e.getMessage(), (Throwable)e);
            blArray[78] = true;
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRelay() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        try {
            byte SOCKS_Version = this.getByteFromClient();
            switch (SOCKS_Version) {
                case 4: {
                    this.comm = new Socks4Impl(this);
                    blArray[79] = true;
                    break;
                }
                case 5: {
                    this.comm = new Socks5Impl(this);
                    blArray[80] = true;
                    break;
                }
                default: {
                    LOGGER.error("Invalid SOKCS version : " + SOCKS_Version);
                    blArray[81] = true;
                    return;
                }
            }
            LOGGER.debug("Accepted SOCKS " + SOCKS_Version + " Request.");
            blArray[82] = true;
            this.comm.authenticate(SOCKS_Version);
            blArray[83] = true;
            this.comm.getClientCommand();
            switch (this.comm.socksCommand) {
                default: {
                    blArray[84] = true;
                    break;
                }
                case 1: {
                    this.comm.connect();
                    blArray[85] = true;
                    this.relay();
                    blArray[86] = true;
                    break;
                }
                case 2: {
                    this.comm.bind();
                    blArray[87] = true;
                    this.relay();
                    blArray[88] = true;
                    break;
                }
                case 3: {
                    this.comm.udp();
                    blArray[89] = true;
                }
            }
            blArray[90] = true;
        }
        catch (Exception SOCKS_Version) {
            void e;
            blArray[91] = true;
            LOGGER.error(e.getMessage(), (Throwable)e);
            blArray[92] = true;
        }
        blArray[93] = true;
    }

    public byte getByteFromClient() throws Exception {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        while (this.m_ClientSocket != null) {
            int b;
            try {
                blArray[94] = true;
                b = this.m_ClientInput.read();
            }
            catch (InterruptedIOException interruptedIOException) {
                blArray[95] = true;
                Thread.yield();
                blArray[96] = true;
                continue;
            }
            blArray[97] = true;
            return (byte)b;
        }
        blArray[98] = true;
        throw new Exception("Interrupted Reading GetByteFromClient()");
    }

    public void relay() {
        boolean isActive;
        boolean[] blArray = ProxyHandler.$jacocoInit();
        boolean bl = true;
        blArray[99] = true;
        while (isActive) {
            blArray[100] = true;
            int dlen = this.checkClientData();
            if (dlen >= 0) {
                blArray[101] = true;
            } else {
                isActive = false;
                blArray[102] = true;
            }
            if (dlen <= 0) {
                blArray[103] = true;
            } else {
                blArray[104] = true;
                this.logData(dlen, "Cli data");
                blArray[105] = true;
                this.sendToServer(this.m_Buffer, dlen);
                blArray[106] = true;
            }
            dlen = this.checkServerData();
            if (dlen >= 0) {
                blArray[107] = true;
            } else {
                isActive = false;
                blArray[108] = true;
            }
            if (dlen <= 0) {
                blArray[109] = true;
            } else {
                blArray[110] = true;
                this.logData(dlen, "Srv data");
                blArray[111] = true;
                this.sendToClient(this.m_Buffer, dlen);
                blArray[112] = true;
            }
            Thread.yield();
            blArray[113] = true;
        }
        blArray[114] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkClientData() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            blArray[115] = true;
            if (this.m_ClientInput == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 5, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[117] = true;
                return -1;
            }
            blArray[116] = true;
            {
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[5, 7, 8] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[126] = true;
                    throw throwable;
                }
                try {
                    dlen = this.m_ClientInput.read(this.m_Buffer, 0, 4096);
                    blArray[118] = true;
                }
                catch (InterruptedIOException e) {
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[119] = true;
                    return 0;
                }
                catch (IOException e) {}
                {
                    blArray[120] = true;
                    LOGGER.debug("Client connection Closed!");
                    blArray[121] = true;
                    this.close();
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[122] = true;
                    return -1;
                }
            }
            {
                if (dlen >= 0) {
                    blArray[123] = true;
                } else {
                    this.close();
                    blArray[124] = true;
                }
                // MONITOREXIT @DISABLED, blocks:[4, 5] lbl37 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[125] = true;
                return dlen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkServerData() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        Object object = this.m_lock;
        synchronized (object) {
            int dlen;
            blArray[127] = true;
            if (this.m_ServerInput == null) {
                // MONITOREXIT @DISABLED, blocks:[0, 5, 11] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[129] = true;
                return -1;
            }
            blArray[128] = true;
            {
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[5, 7, 8] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[139] = true;
                    throw throwable;
                }
                try {
                    dlen = this.m_ServerInput.read(this.m_Buffer, 0, 4096);
                    blArray[130] = true;
                }
                catch (InterruptedIOException e) {
                    // MONITOREXIT @DISABLED, blocks:[5, 6, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[131] = true;
                    return 0;
                }
                catch (IOException e) {}
                {
                    blArray[132] = true;
                    LOGGER.debug("Server connection Closed!");
                    blArray[133] = true;
                    this.close();
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 7] lbl29 : MonitorExitStatement: MONITOREXIT : var2_2
                    blArray[134] = true;
                    return -1;
                }
            }
            {
                if (dlen >= 0) {
                    blArray[135] = true;
                } else {
                    blArray[136] = true;
                    this.close();
                    blArray[137] = true;
                }
                // MONITOREXIT @DISABLED, blocks:[4, 5] lbl38 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[138] = true;
                return dlen;
            }
        }
    }

    private void logData(int traffic, String dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javasocksproxyserver/ProxyHandler.logData must not be null");
        }
        boolean[] blArray = ProxyHandler.$jacocoInit();
        Object[] objectArray = new Object[6];
        objectArray[0] = dataSource;
        blArray[140] = true;
        objectArray[1] = Utils.getSocketInfo(this.m_ClientSocket);
        blArray[141] = true;
        objectArray[2] = this.comm.m_ServerIP.getHostName();
        blArray[142] = true;
        objectArray[3] = this.comm.m_ServerIP.getHostAddress();
        blArray[143] = true;
        objectArray[4] = this.comm.m_nServerPort;
        objectArray[5] = traffic;
        blArray[144] = true;
        LOGGER.debug(String.format("%s : %s >> <%s/%s:%d> : %d bytes.", objectArray));
        blArray[145] = true;
    }

    public int getPort() {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        blArray[146] = true;
        return this.m_ServerSocket.getPort();
    }

    static {
        boolean[] blArray = ProxyHandler.$jacocoInit();
        LOGGER = LoggerFactory.getLogger(ProxyHandler.class);
        blArray[147] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-5103566954311219896L, (String)"org/bbottema/javasocksproxyserver/ProxyHandler", (int)148);
        }
        return blArray;
    }
}

