/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacoco.agent.rt.internal_c13123e.Offline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public Utils() {
        boolean[] blArray = Utils.$jacocoInit();
        blArray[0] = true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static InetAddress calcInetAddress(byte[] addr) {
        InetAddress IA;
        if (addr == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.calcInetAddress must not be null");
        }
        boolean[] blArray = Utils.$jacocoInit();
        StringBuilder sIA = new StringBuilder();
        if (addr.length < 4) {
            blArray[1] = true;
            LOGGER.error("calcInetAddress() - Invalid length of IP v4 - " + addr.length + " bytes");
            blArray[2] = true;
            return null;
        }
        boolean bl = false;
        blArray[3] = true;
        while (true) {
            void i;
            if (i >= 4) break;
            blArray[5] = true;
            sIA.append(Utils.byte2int(addr[i]));
            blArray[6] = true;
            if (i >= 3) {
                blArray[7] = true;
            } else {
                sIA.append(".");
                blArray[8] = true;
            }
            ++i;
            blArray[9] = true;
        }
        blArray[4] = true;
        try {
            IA = InetAddress.getByName(sIA.toString());
        }
        catch (UnknownHostException e) {
            blArray[10] = true;
            return null;
        }
        blArray[11] = true;
        return IA;
    }

    public static int byte2int(byte by) {
        int n;
        int b;
        boolean[] blArray = Utils.$jacocoInit();
        if (b < 0) {
            n = 256 + b;
            blArray[12] = true;
        } else {
            n = b;
            blArray[13] = true;
        }
        blArray[14] = true;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static int calcPort(byte by, byte by2) {
        void Lo;
        byte Hi;
        boolean[] blArray = Utils.$jacocoInit();
        blArray[15] = true;
        return Utils.byte2int(Hi) << 8 | Utils.byte2int((byte)Lo);
    }

    @NotNull
    public static String iP2Str(InetAddress IP) {
        String string;
        if (IP == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.iP2Str must not be null");
        }
        boolean[] blArray = Utils.$jacocoInit();
        if (IP == null) {
            string = "NA/NA";
            blArray[16] = true;
        } else {
            Object[] objectArray = new Object[2];
            blArray[17] = true;
            objectArray[0] = IP.getHostName();
            objectArray[1] = IP.getHostAddress();
            string = String.format("%s/%s", objectArray);
            blArray[18] = true;
        }
        blArray[19] = true;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.iP2Str must not return null");
        }
        return string;
    }

    @NotNull
    public static String getSocketInfo(Socket sock) {
        String string;
        if (sock == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not be null");
        }
        boolean[] blArray = Utils.$jacocoInit();
        if (sock == null) {
            string = "<NA/NA:0>";
            blArray[20] = true;
        } else {
            Object[] objectArray = new Object[2];
            blArray[21] = true;
            objectArray[0] = Utils.iP2Str(sock.getInetAddress());
            objectArray[1] = sock.getPort();
            string = String.format("<%s:%d>", objectArray);
            blArray[22] = true;
        }
        blArray[23] = true;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not return null");
        }
        return string;
    }

    @NotNull
    public static String getSocketInfo(DatagramPacket DGP) {
        String string;
        if (DGP == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not be null");
        }
        boolean[] blArray = Utils.$jacocoInit();
        if (DGP == null) {
            string = "<NA/NA:0>";
            blArray[24] = true;
        } else {
            Object[] objectArray = new Object[2];
            blArray[25] = true;
            objectArray[0] = Utils.iP2Str(DGP.getAddress());
            objectArray[1] = DGP.getPort();
            string = String.format("<%s:%d>", objectArray);
            blArray[26] = true;
        }
        blArray[27] = true;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javasocksproxyserver/Utils.getSocketInfo must not return null");
        }
        return string;
    }

    static {
        boolean[] blArray = Utils.$jacocoInit();
        LOGGER = LoggerFactory.getLogger(Utils.class);
        blArray[28] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)1057406359483446178L, (String)"org/bbottema/javasocksproxyserver/Utils", (int)29);
        }
        return blArray;
    }
}

