/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import no.unit.nva.auth.CachedJwtProvider;
import no.unit.nva.auth.CognitoAuthenticator;
import no.unit.nva.auth.CognitoCredentials;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;

public class AuthorizedBackendClient {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String API_HOST = "API_HOST";
    private final HttpClient httpClient;
    private final CachedJwtProvider cachedJwtProvider;
    private final boolean bearerTokenIsNotInjectedDirectly;
    private String bearerToken;

    protected AuthorizedBackendClient(HttpClient httpClient, String bearerToken, CognitoCredentials cognitoCredentials) {
        this.httpClient = httpClient;
        this.bearerToken = bearerToken;
        this.cachedJwtProvider = new CachedJwtProvider(new CognitoAuthenticator(httpClient, cognitoCredentials), Clock.systemDefaultZone());
        this.bearerTokenIsNotInjectedDirectly = Objects.isNull(bearerToken);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithCognitoCredentials(CognitoCredentials cognitoCredentials) {
        return AuthorizedBackendClient.prepareWithCognitoCredentials(HttpClient.newHttpClient(), cognitoCredentials);
    }

    public static AuthorizedBackendClient prepareWithCognitoCredentials(HttpClient httpClient, CognitoCredentials cognitoApiClientCredentials) {
        return new AuthorizedBackendClient(httpClient, null, cognitoApiClientCredentials);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithBearerToken(String bearerToken) {
        return AuthorizedBackendClient.prepareWithBearerToken(HttpClient.newHttpClient(), bearerToken);
    }

    public static AuthorizedBackendClient prepareWithBearerToken(HttpClient httpClient, String bearerToken) {
        return new AuthorizedBackendClient(httpClient, bearerToken, null);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithBearerTokenAndCredentials(HttpClient httpClient, String bearerToken, CognitoCredentials cognitoCredentials) {
        return new AuthorizedBackendClient(httpClient, bearerToken, cognitoCredentials);
    }

    public <T> HttpResponse<T> send(HttpRequest.Builder request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        this.refreshTokenIfExpired();
        HttpRequest authorizedRequest = request.setHeader(AUTHORIZATION_HEADER, this.bearerToken).build();
        if (this.hasInvalidBackendHost(authorizedRequest)) {
            throw new IllegalArgumentException("Request host does not match the backend hostname or API_HOST is not set");
        }
        return this.httpClient.send(authorizedRequest, responseBodyHandler);
    }

    private boolean hasInvalidBackendHost(HttpRequest request) {
        return new Environment().readEnvOpt(API_HOST).map(hostName -> !request.uri().getHost().equals(hostName)).orElse(true);
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest.Builder request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        this.refreshTokenIfExpired();
        HttpRequest authorizedRequest = request.setHeader(AUTHORIZATION_HEADER, this.bearerToken).build();
        return this.httpClient.sendAsync(authorizedRequest, responseBodyHandler);
    }

    @JacocoGenerated
    protected String getBearerToken() {
        return this.bearerToken;
    }

    private void refreshTokenIfExpired() {
        if (this.bearerTokenIsNotInjectedDirectly) {
            this.bearerToken = this.createBearerToken(((DecodedJWT)this.cachedJwtProvider.getValue()).getToken());
        }
    }

    private String createBearerToken(String accessToken) {
        return "Bearer " + accessToken;
    }
}

