/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.core;

import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import nva.commons.core.attempt.Try;

public final class SingletonCollector {
    public static final int SINGLETON = 1;
    public static final int ONLY_ELEMENT = 0;
    public static final String SINGLETON_EXPECTED_ERROR_TEMPLATE = "Expected a single value, but %d were found";
    public static final String SINGLETON_OR_NULL_EXPECTED_ERROR_TEMPLATE = "Expected zero or a single value, but %d were found";

    private SingletonCollector() {
    }

    public static <T> Collector<T, ?, T> collect() {
        return Collectors.collectingAndThen(Collectors.toList(), SingletonCollector::get);
    }

    public static <T> Collector<T, ?, T> collectOrElse(T alternative) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> SingletonCollector.orElse(list, alternative));
    }

    public static <T, E extends Exception> Collector<T, ?, Try<T>> tryCollect() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> Try.attempt(() -> SingletonCollector.get(list)));
    }

    private static <T, E extends Exception> T get(List<T> list) {
        if (list.size() != 1) {
            throw SingletonCollector.defaultException(list);
        }
        return list.get(0);
    }

    private static <T> IllegalStateException defaultException(List<T> list) {
        return new IllegalStateException(String.format(SINGLETON_EXPECTED_ERROR_TEMPLATE, list.size()));
    }

    private static <T> T orElse(List<T> list, T alternative) {
        if (list.size() < 1) {
            return alternative;
        }
        if (list.size() > 1) {
            throw new IllegalStateException(String.format(SINGLETON_OR_NULL_EXPECTED_ERROR_TEMPLATE, list.size()));
        }
        return list.get(0);
    }
}

