/*
 * Decompiled with CFR 0.152.
 */
package no.unit.commons.apigateway.authentication;

import com.amazonaws.services.lambda.runtime.Context;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import no.unit.commons.apigateway.authentication.AuthPolicy;
import no.unit.commons.apigateway.authentication.AuthorizerResponse;
import no.unit.commons.apigateway.authentication.StatementElement;
import nva.commons.apigateway.RequestInfo;
import nva.commons.apigateway.RestRequestHandler;
import nva.commons.apigateway.exceptions.ApiGatewayException;
import nva.commons.apigateway.exceptions.ForbiddenException;
import nva.commons.core.Environment;
import nva.commons.core.JsonUtils;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestAuthorizer
extends RestRequestHandler<Void, AuthorizerResponse> {
    public static final String EXECUTE_API_ACTION = "execute-api:Invoke";
    public static final String ALLOW_EFFECT = "Allow";
    public static final String ANY_RESOURCE = "*";
    public static final String ANY_HTTP_METHOD = "*";
    public static final String ALL_PATHS = "*";
    public static final String PATH_DELIMITER = "/";
    public static final int API_GATEWAY_IDENTIFIER_INDEX = 0;
    public static final int STAGE_INDEX = 1;
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String DENY_EFFECT = "Deny";
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthorizer.class);

    public RequestAuthorizer(Environment environment) {
        super(Void.class, environment);
    }

    protected AuthorizerResponse processInput(Void input, RequestInfo requestInfo, Context context) throws ApiGatewayException {
        logger.debug("Requesting authorizing: " + this.principalId());
        this.secretCheck(requestInfo);
        String resource = this.formatPolicyResource(requestInfo.getMethodArn());
        AuthPolicy authPolicy = this.createAllowAuthPolicy(resource);
        return this.createResponse(authPolicy);
    }

    protected Integer getSuccessStatusCode(Void input, AuthorizerResponse output) {
        return 200;
    }

    protected void writeOutput(Void input, AuthorizerResponse output) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));){
            String responseJson = JsonUtils.objectMapper.writeValueAsString((Object)output);
            writer.write(responseJson);
        }
    }

    protected void writeExpectedFailure(Void input, ApiGatewayException exception, String requestId) throws IOException {
        try {
            this.writeFailure();
        }
        catch (ForbiddenException e) {
            throw new IOException(e);
        }
    }

    protected void writeUnexpectedFailure(Void input, Exception exception, String requestId) throws IOException {
        try {
            this.writeFailure();
        }
        catch (ForbiddenException e) {
            throw new IOException(e);
        }
    }

    protected String formatPolicyResource(String methodArn) {
        String[] resourcePathComponents = methodArn.split(PATH_DELIMITER);
        String apiGateway = resourcePathComponents[0];
        String stage = resourcePathComponents[1];
        return String.join((CharSequence)PATH_DELIMITER, apiGateway, stage, "*", "*");
    }

    protected AuthPolicy createAllowAuthPolicy(String methodArn) throws ForbiddenException {
        logger.info("Allowed to access: " + this.principalId());
        StatementElement statement = StatementElement.newBuilder().withResource(methodArn).withAction(EXECUTE_API_ACTION).withEffect(ALLOW_EFFECT).build();
        return AuthPolicy.newBuilder().withStatement(Collections.singletonList(statement)).build();
    }

    protected AuthPolicy createDenyAuthPolicy() throws ForbiddenException {
        logger.info("Denied access: " + this.principalId());
        StatementElement statement = StatementElement.newBuilder().withResource("*").withAction(EXECUTE_API_ACTION).withEffect(DENY_EFFECT).build();
        return AuthPolicy.newBuilder().withStatement(Collections.singletonList(statement)).build();
    }

    protected abstract String principalId() throws ForbiddenException;

    protected abstract String fetchSecret() throws ForbiddenException;

    protected void secretCheck(RequestInfo requestInfo) throws ForbiddenException {
        Optional.ofNullable((String)requestInfo.getHeaders().get(AUTHORIZATION_HEADER)).map(this::validateSecret).filter(this::validationSucceeded).orElseThrow(ForbiddenException::new);
    }

    private Boolean validationSucceeded(Boolean check) {
        return check;
    }

    private boolean validateSecret(String clientSecret) {
        String correctSecret = (String)Try.attempt(this::fetchSecret).orElseThrow(this::logErrorAndThrowException);
        return clientSecret.equals(correctSecret);
    }

    private void writeFailure() throws IOException, ForbiddenException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));){
            String principalId = (String)Try.attempt(this::principalId).orElseThrow(this::logErrorAndThrowException);
            AuthorizerResponse denyResponse = AuthorizerResponse.newBuilder().withPrincipalId(principalId).withPolicyDocument(this.createDenyAuthPolicy()).build();
            String response = JsonUtils.objectMapper.writeValueAsString((Object)denyResponse);
            writer.write(response);
        }
    }

    private AuthorizerResponse createResponse(AuthPolicy authPolicy) throws ForbiddenException {
        return AuthorizerResponse.newBuilder().withPrincipalId(this.principalId()).withPolicyDocument(authPolicy).build();
    }

    private RuntimeException logErrorAndThrowException(Failure<String> failure) {
        logger.error(failure.getException().getMessage(), (Throwable)failure.getException());
        return new RuntimeException(failure.getException());
    }

    protected void checkHeaders(RequestInfo requestInfo) {
    }
}

