/*
 * Decompiled with CFR 0.152.
 */
package no.unit.commons.apigateway.authentication;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayCustomAuthorizerEvent;
import java.util.Collections;
import java.util.Optional;
import no.unit.commons.apigateway.authentication.AuthPolicy;
import no.unit.commons.apigateway.authentication.AuthorizerResponse;
import no.unit.commons.apigateway.authentication.ForbiddenException;
import no.unit.commons.apigateway.authentication.StatementElement;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.core.exceptions.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestAuthorizer
implements RequestHandler<APIGatewayCustomAuthorizerEvent, AuthorizerResponse> {
    public static final String EXECUTE_API_ACTION = "execute-api:Invoke";
    public static final String ALLOW_EFFECT = "Allow";
    public static final String ANY_RESOURCE = "*";
    public static final String ANY_HTTP_METHOD = "*";
    public static final String ALL_PATHS = "*";
    public static final String PATH_DELIMITER = "/";
    public static final int API_GATEWAY_IDENTIFIER_INDEX = 0;
    public static final int STAGE_INDEX = 1;
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String COULD_NOT_READ_PRINCIPAL_ID_ERROR = "Error while trying to get the principal ID.";
    private static final String DENY_EFFECT = "Deny";
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthorizer.class);

    protected RequestAuthorizer() {
    }

    public AuthorizerResponse handleRequest(APIGatewayCustomAuthorizerEvent input, Context context) {
        return (AuthorizerResponse)Try.attempt(() -> this.callerIsAllowedToPerformAction(input)).map(callerIsAuthorized -> this.formatPolicyResource(input.getMethodArn())).map(this::createAllowAuthPolicy).map(this::createResponse).orElse(fail -> this.createForbiddenResponse(fail.getException()));
    }

    protected String formatPolicyResource(String methodArn) {
        String[] resourcePathComponents = methodArn.split(PATH_DELIMITER);
        String apiGateway = resourcePathComponents[0];
        String stage = resourcePathComponents[1];
        return String.join((CharSequence)PATH_DELIMITER, apiGateway, stage, "*", "*");
    }

    protected AuthPolicy createAllowAuthPolicy(String methodArn) {
        StatementElement statement = StatementElement.newBuilder().withResource(methodArn).withAction(EXECUTE_API_ACTION).withEffect(ALLOW_EFFECT).build();
        return AuthPolicy.newBuilder().withStatement(Collections.singletonList(statement)).build();
    }

    protected AuthPolicy createDenyAuthPolicy() {
        StatementElement statement = StatementElement.newBuilder().withResource("*").withAction(EXECUTE_API_ACTION).withEffect(DENY_EFFECT).build();
        return AuthPolicy.newBuilder().withStatement(Collections.singletonList(statement)).build();
    }

    protected abstract String principalId();

    protected abstract String fetchSecret() throws ForbiddenException;

    protected boolean callerIsAllowedToPerformAction(APIGatewayCustomAuthorizerEvent requestInfo) throws ForbiddenException {
        return Optional.ofNullable((String)requestInfo.getHeaders().get(AUTHORIZATION_HEADER)).map(this::validateSecret).filter(this::validationSucceeded).orElseThrow(ForbiddenException::new);
    }

    private String readPrincipalId() {
        try {
            return this.principalId();
        }
        catch (Exception e) {
            throw new RuntimeException(COULD_NOT_READ_PRINCIPAL_ID_ERROR, e);
        }
    }

    private AuthorizerResponse createForbiddenResponse(Exception exception) {
        logger.warn(ExceptionUtils.stackTraceInSingleLine((Exception)exception));
        return AuthorizerResponse.newBuilder().withPrincipalId(this.readPrincipalId()).withPolicyDocument(this.createDenyAuthPolicy()).build();
    }

    private Boolean validationSucceeded(Boolean check) {
        return check;
    }

    private boolean validateSecret(String clientSecret) {
        String correctSecret = (String)Try.attempt(this::fetchSecret).orElseThrow(this::logErrorAndThrowException);
        return clientSecret.equals(correctSecret);
    }

    private AuthorizerResponse createResponse(AuthPolicy authPolicy) {
        return AuthorizerResponse.newBuilder().withPrincipalId(this.readPrincipalId()).withPolicyDocument(authPolicy).build();
    }

    private RuntimeException logErrorAndThrowException(Failure<String> failure) {
        logger.error(failure.getException().getMessage(), (Throwable)failure.getException());
        return new RuntimeException(failure.getException());
    }
}

