/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.model.contexttypes;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.net.URI;
import java.net.URL;
import java.util.List;
import no.unit.nva.model.contexttypes.Book;
import no.unit.nva.model.exceptions.InvalidIsbnException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public class Degree
extends Book {
    public Degree() {
    }

    private Degree(Builder builder) throws InvalidIsbnException {
        this.setSeriesTitle(builder.seriesTitle);
        this.setSeriesNumber(builder.seriesNumber);
        this.setPublisher(builder.publisher);
        this.setIsbnList(builder.isbnList);
        this.setUrl(builder.url);
        this.setLinkedContext(builder.linkedContext);
    }

    public static final class Builder {
        private String seriesTitle;
        private String seriesNumber;
        private String publisher;
        private List<String> isbnList;
        private URL url;
        private URI linkedContext;

        public Builder withSeriesTitle(String seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        public Builder withSeriesNumber(String seriesNumber) {
            this.seriesNumber = seriesNumber;
            return this;
        }

        public Builder withPublisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder withIsbnList(List<String> isbnList) {
            this.isbnList = isbnList;
            return this;
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withLinkedContext(String linkedContext) {
            this.linkedContext = URI.create(linkedContext);
            return this;
        }

        public Degree build() throws InvalidIsbnException {
            return new Degree(this);
        }
    }
}

